/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format.parser;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.miaixz.bus.core.center.date.format.parser.DateParser;
import org.miaixz.bus.core.center.date.format.parser.RegexDateParser;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.xyz.ListKit;

public class RegexListDateParser
implements DateParser,
Serializable {
    private static final long serialVersionUID = -1L;
    private final List<Pattern> list;

    public RegexListDateParser(List<Pattern> list) {
        this.list = list;
    }

    public static RegexListDateParser of(Pattern ... args) {
        return new RegexListDateParser(ListKit.of(args));
    }

    public RegexListDateParser addRegex(String regex) {
        return this.addPattern(Pattern.compile(regex, 2));
    }

    public RegexListDateParser addPattern(Pattern pattern) {
        this.list.add(pattern);
        return this;
    }

    @Override
    public Date parse(CharSequence source) throws DateException {
        for (Pattern pattern : this.list) {
            Matcher matcher = pattern.matcher(source);
            if (!matcher.matches()) continue;
            return RegexDateParser.parse(matcher);
        }
        throw new DateException("No valid pattern for date string: [{}]", source);
    }
}

