/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.function;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Map;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.mutable.MutableEntry;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.LambdaKit;
import org.miaixz.bus.core.xyz.LookupKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ReflectKit;

public class LambdaFactory {
    private static final Map<MutableEntry<Class<?>, Executable>, Object> CACHE = new WeakConcurrentMap();

    private LambdaFactory() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public static <F> F build(Class<F> functionInterfaceType, Class<?> methodClass, String methodName, Class<?> ... paramTypes) {
        return LambdaFactory.build(functionInterfaceType, MethodKit.getMethod(methodClass, methodName, paramTypes));
    }

    public static <F> F build(Class<F> functionInterfaceType, Executable executable) {
        Assert.notNull(functionInterfaceType);
        Assert.notNull(executable);
        MutableEntry<Class<F>, Executable> cacheKey = new MutableEntry<Class<F>, Executable>(functionInterfaceType, executable);
        return (F)CACHE.computeIfAbsent(cacheKey, key -> LambdaFactory.doBuildWithoutCache(functionInterfaceType, executable));
    }

    private static <F> F doBuildWithoutCache(Class<F> funcType, Executable executable) {
        ReflectKit.setAccessible(executable);
        Method invokeMethod = LambdaKit.getInvokeMethod(funcType);
        try {
            return (F)LambdaFactory.metaFactory(funcType, invokeMethod, executable).getTarget().invoke();
        }
        catch (Throwable e) {
            throw new InternalException(e);
        }
    }

    private static CallSite metaFactory(Class<?> funcType, Method funcMethod, Executable executable) throws LambdaConversionException {
        MethodHandles.Lookup caller = LookupKit.lookup(executable.getDeclaringClass());
        String invokeName = funcMethod.getName();
        MethodType invokedType = MethodType.methodType(funcType);
        Class<?>[] paramTypes = funcMethod.getParameterTypes();
        MethodType samMethodType = MethodType.methodType(funcMethod.getReturnType(), paramTypes);
        MethodHandle implMethodHandle = LookupKit.unreflect(executable);
        if (ClassKit.isSerializable(funcType)) {
            return LambdaMetafactory.altMetafactory(caller, invokeName, invokedType, samMethodType, implMethodHandle, MethodKit.methodType(executable), 1);
        }
        return LambdaMetafactory.metafactory(caller, invokeName, invokedType, samMethodType, implMethodHandle, MethodKit.methodType(executable));
    }
}

