/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.iterator;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.miaixz.bus.core.center.iterator.ComputeIterator;
import org.miaixz.bus.core.center.iterator.IterableIterator;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;

public class LineIterator
extends ComputeIterator<String>
implements IterableIterator<String>,
Closeable,
Serializable {
    private static final long serialVersionUID = -1L;
    private final BufferedReader bufferedReader;

    public LineIterator(InputStream in, Charset charset) throws IllegalArgumentException {
        this(IoKit.toReader(in, charset));
    }

    public LineIterator(Reader reader) throws IllegalArgumentException {
        Assert.notNull(reader, "Reader must not be null", new Object[0]);
        this.bufferedReader = IoKit.toBuffered(reader);
    }

    @Override
    protected String computeNext() {
        try {
            String line;
            do {
                if ((line = this.bufferedReader.readLine()) != null) continue;
                return null;
            } while (!this.isValidLine(line));
            return line;
        }
        catch (IOException ioe) {
            this.close();
            throw new InternalException(ioe);
        }
    }

    @Override
    public void close() {
        super.finish();
        IoKit.closeQuietly(this.bufferedReader);
    }

    protected boolean isValidLine(String line) {
        return true;
    }
}

