/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.map;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.miaixz.bus.core.center.map.FunctionKeyMap;
import org.miaixz.bus.core.center.map.MapBuilder;
import org.miaixz.bus.core.xyz.StringKit;

public class CamelCaseMap<K, V>
extends FunctionKeyMap<K, V> {
    private static final long serialVersionUID = -1L;

    public CamelCaseMap() {
        this(16);
    }

    public CamelCaseMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CamelCaseMap(Map<? extends K, ? extends V> m) {
        this(0.75f, m);
    }

    public CamelCaseMap(float loadFactor, Map<? extends K, ? extends V> m) {
        this(m.size(), loadFactor);
        this.putAll(m);
    }

    public CamelCaseMap(int initialCapacity, float loadFactor) {
        this(MapBuilder.of(new HashMap(initialCapacity, loadFactor)));
    }

    CamelCaseMap(MapBuilder<K, V> emptyMapBuilder) {
        super(emptyMapBuilder.build(), (Function<Object, Object> & Serializable)key -> {
            if (key instanceof CharSequence) {
                key = StringKit.toCamelCase(key.toString());
            }
            return key;
        });
    }
}

