/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.map;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import org.miaixz.bus.core.text.StringJoiner;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.StringKit;

public class MapJoiner {
    private final StringJoiner joiner;
    private final String keyValueSeparator;

    public MapJoiner(StringJoiner joiner, String keyValueSeparator) {
        this.joiner = joiner;
        this.keyValueSeparator = keyValueSeparator;
    }

    public static MapJoiner of(String separator, String keyValueSeparator) {
        return MapJoiner.of(StringJoiner.of(separator), keyValueSeparator);
    }

    public static MapJoiner of(StringJoiner joiner, String keyValueSeparator) {
        return new MapJoiner(joiner, keyValueSeparator);
    }

    public <K, V> MapJoiner append(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        return this.append(map.entrySet().iterator(), predicate);
    }

    public <K, V> MapJoiner append(Iterator<? extends Map.Entry<K, V>> parts, Predicate<Map.Entry<K, V>> predicate) {
        if (null == parts) {
            return this;
        }
        while (parts.hasNext()) {
            Map.Entry<K, V> entry = parts.next();
            if (null != predicate && !predicate.test(entry)) continue;
            this.joiner.append(StringJoiner.of(this.keyValueSeparator).append(entry.getKey()).append(entry.getValue()));
        }
        return this;
    }

    public MapJoiner append(String ... params) {
        if (ArrayKit.isNotEmpty(params)) {
            this.joiner.append(StringKit.concat(false, params));
        }
        return this;
    }

    public String toString() {
        return this.joiner.toString();
    }
}

