/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.map.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.xyz.MapKit;

public class SafeConcurrentHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = -1L;

    public SafeConcurrentHashMap() {
    }

    public SafeConcurrentHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public SafeConcurrentHashMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    public SafeConcurrentHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SafeConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        if (Keys.IS_JDK8) {
            return MapKit.computeIfAbsentForJdk8(this, key, mappingFunction);
        }
        return super.computeIfAbsent(key, mappingFunction);
    }
}

