/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.miaixz.bus.core.center.stream.EasyStream;
import org.miaixz.bus.core.center.stream.WrappedStream;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.mutable.MutableInt;
import org.miaixz.bus.core.lang.mutable.MutableObject;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollectorKit;

public interface TerminableWrappedStream<T, S extends TerminableWrappedStream<T, S>>
extends WrappedStream<T, S> {
    @Override
    default public List<T> toList() {
        return this.toColl(ArrayList::new);
    }

    default public List<T> toUnmodifiableList() {
        return Collections.unmodifiableList(this.toList());
    }

    default public Set<T> toSet() {
        return this.toColl(HashSet::new);
    }

    default public Set<T> toUnmodifiableSet() {
        return Collections.unmodifiableSet(this.toSet());
    }

    default public <C extends Collection<T>> C toColl(Supplier<C> collectionFactory) {
        Objects.requireNonNull(collectionFactory);
        return (C)((Collection)this.unwrap().collect(Collectors.toCollection(collectionFactory)));
    }

    default public <K> Map<K, T> toMap(Function<? super T, ? extends K> keyMapper) {
        return this.toMap(keyMapper, Function.identity());
    }

    default public <K, U> Map<K, U> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.toMap(keyMapper, valueMapper, (l, r) -> r);
    }

    default public <K, U> Map<K, U> toUnmodifiableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collections.unmodifiableMap(this.toMap(keyMapper, valueMapper));
    }

    default public <K, U> Map<K, U> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return this.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    default public <K, U> Map<K, U> toUnmodifiableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collections.unmodifiableMap(this.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new));
    }

    default public <K, U, M extends Map<K, U>> M toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        Objects.requireNonNull(mergeFunction);
        Objects.requireNonNull(mapSupplier);
        return (M)((Map)this.unwrap().collect(CollectorKit.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier)));
    }

    default public Map<Integer, T> toIdxMap() {
        return this.toIdxMap(Function.identity());
    }

    default public <U> Map<Integer, U> toIdxMap(Function<? super T, ? extends U> valueMapper) {
        MutableInt index = new MutableInt(-1);
        return EasyStream.of(((TerminableWrappedStream)this.sequential()).toList()).toMap(e -> index.incrementAndGet(), valueMapper, (l, r) -> r);
    }

    default public <R> Map<T, R> toZip(Iterable<R> other) {
        Objects.requireNonNull(other);
        Iterator iterator = Optional.ofNullable(other).map(Iterable::iterator).orElseGet(Collections::emptyIterator);
        if (this.isParallel()) {
            List<T> keyList = this.toList();
            HashMap<T, Object> map = new HashMap<T, Object>(keyList.size());
            for (T key : keyList) {
                map.put(key, iterator.hasNext() ? (Object)iterator.next() : null);
            }
            return map;
        }
        return this.toMap(Function.identity(), e -> iterator.hasNext() ? iterator.next() : null);
    }

    default public java.util.Optional<T> findFirst(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return this.unwrap().filter(predicate).findFirst();
    }

    default public int findFirstIdx(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        MutableInt index = new MutableInt(-1);
        this.unwrap().filter((? super T e) -> {
            index.increment();
            return predicate.test(e);
        }).findFirst();
        return index.get();
    }

    default public java.util.Optional<T> findLast() {
        MutableObject<Object> last = new MutableObject<Object>(null);
        this.spliterator().forEachRemaining(last::set);
        return java.util.Optional.ofNullable(last.get());
    }

    default public java.util.Optional<T> findLast(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        MutableObject<Object> last = new MutableObject<Object>(null);
        this.spliterator().forEachRemaining(e -> {
            if (predicate.test(e)) {
                last.set(e);
            }
        });
        return java.util.Optional.ofNullable(last.get());
    }

    default public int findLastIdx(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        MutableInt idxRef = new MutableInt(-1);
        this.forEachIdx((e, i) -> {
            if (predicate.test(e)) {
                idxRef.set((Number)i);
            }
        });
        return idxRef.get();
    }

    default public java.util.Optional<T> at(Integer idx) {
        return Optional.ofNullable(idx).map((? super T i) -> ArrayKit.get(this.toArray(), i)).toOptional();
    }

    default public boolean isEmpty() {
        return !this.findAny().isPresent();
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public String join() {
        return this.join("");
    }

    default public String join(CharSequence delimiter) {
        return this.join(delimiter, "", "");
    }

    default public String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.unwrap().map(String::valueOf).collect(CollectorKit.joining(delimiter, prefix, suffix, Function.identity()));
    }

    default public <K> Map<K, List<T>> group(Function<? super T, ? extends K> classifier) {
        return this.group(classifier, Collectors.toList());
    }

    default public <K, A, D> Map<K, D> group(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return this.group(classifier, HashMap::new, downstream);
    }

    default public <K, D, A, M extends Map<K, D>> M group(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Objects.requireNonNull(classifier);
        Objects.requireNonNull(mapFactory);
        Objects.requireNonNull(downstream);
        return (M)((Map)this.unwrap().collect(CollectorKit.groupingBy(classifier, mapFactory, downstream)));
    }

    default public Map<Boolean, List<T>> partition(Predicate<T> predicate) {
        return this.partition(predicate, ArrayList::new);
    }

    default public <C extends Collection<T>> Map<Boolean, C> partition(Predicate<T> predicate, Supplier<C> collFactory) {
        return this.partition(predicate, Collectors.toCollection(collFactory));
    }

    default public <R> Map<Boolean, R> partition(Predicate<T> predicate, Collector<T, ?, R> downstream) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(downstream);
        return this.unwrap().collect(Collectors.partitioningBy(predicate, downstream));
    }

    default public void forEachIdx(BiConsumer<? super T, Integer> action) {
        Objects.requireNonNull(action);
        MutableInt index = new MutableInt(-1);
        this.unwrap().forEach(e -> action.accept(e, index.incrementAndGet()));
    }

    default public void forEachOrderedIdx(BiConsumer<? super T, Integer> action) {
        Objects.requireNonNull(action);
        MutableInt index = new MutableInt(-1);
        this.unwrap().forEachOrdered(e -> action.accept(e, index.incrementAndGet()));
    }
}

