/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.stream.spliterators;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TakeWhileSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<? super T> predicate;
    private boolean isContinue = true;

    TakeWhileSpliterator(Spliterator<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    public static <T> TakeWhileSpliterator<T> create(Spliterator<T> source, Predicate<? super T> predicate) {
        return new TakeWhileSpliterator<T>(source, predicate);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean hasNext = true;
        while (this.isContinue && hasNext) {
            hasNext = this.source.tryAdvance(e -> {
                if (this.predicate.test(e)) {
                    action.accept(e);
                } else {
                    this.isContinue = false;
                }
            });
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.isContinue ? this.source.estimateSize() : 0L;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFBFBF;
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.source.getComparator();
    }
}

