/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec;

import org.miaixz.bus.core.center.regex.Pattern;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Luhn {
    public static boolean check(String text) {
        if (StringKit.isBlank(text)) {
            return false;
        }
        if (!PatternKit.isMatch(Pattern.NUMBERS_PATTERN, (CharSequence)text)) {
            return false;
        }
        return Luhn.sum(text) % 10 == 0;
    }

    public static int getCheckDigit(String str, boolean withCheckDigit) {
        if (withCheckDigit) {
            str = str.substring(0, str.length() - 1);
        }
        return 10 - Luhn.sum(str + "0") % 10;
    }

    private static int sum(String text) {
        char[] strArray = text.toCharArray();
        int n = strArray.length;
        int sum = strArray[n - 1] - 48;
        for (int i = 2; i <= n; ++i) {
            int a = strArray[n - i] - 48;
            if ((i & 1) == 0) {
                a *= 2;
            }
            sum += a / 10 + a % 10;
        }
        return sum;
    }
}

