/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary;

import java.io.Serializable;
import org.miaixz.bus.core.codec.Decoder;
import org.miaixz.bus.core.codec.Encoder;

public class Z85
implements Encoder<byte[], String>,
Decoder<String, byte[]>,
Serializable {
    private static final long serialVersionUID = -1L;
    private static final char[] encodeTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '-', ':', '+', '=', '^', '!', '/', '*', '?', '&', '<', '>', '(', ')', '[', ']', '{', '}', '@', '%', '$', '#'};
    private static final int[] decodeTable = new int[]{0, 68, 0, 84, 83, 82, 72, 0, 75, 76, 70, 65, 0, 63, 62, 69, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 64, 0, 73, 66, 74, 71, 81, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 77, 0, 78, 67, 0, 0, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 79, 0, 80, 0, 0};

    @Override
    public String encode(byte[] data) {
        int length = data.length;
        int remainder = length & 3;
        int padding = 4 - (remainder == 0 ? 4 : remainder);
        char[] chars = new char[length + (length >>> 2) + (remainder == 0 ? 0 : 1)];
        int idx = 0;
        long value = 0L;
        for (int i = 0; i < length + padding; ++i) {
            boolean isPadBlock = i >= length;
            value = (value << 8) + (long)(isPadBlock ? 0 : data[i] & 0xFF);
            if ((i + 1 & 3) != 0) continue;
            for (int j = 0; j < 5; ++j) {
                if (j > 0) {
                    value /= 85L;
                }
                if (isPadBlock && j < padding) continue;
                int code = (int)(value % 85L);
                chars[idx + 4 - j] = encodeTable[code];
            }
            idx += 5;
            value = 0L;
        }
        return new String(chars);
    }

    @Override
    public byte[] decode(String encoded) {
        int remainder = encoded.length() % 5;
        int padding = 5 - (remainder == 0 ? 5 : remainder);
        StringBuilder encodedBuilder = new StringBuilder(encoded);
        for (int p = 0; p < padding; ++p) {
            encodedBuilder.append(encodeTable[encodeTable.length - 1]);
        }
        encoded = encodedBuilder.toString();
        int length = encoded.length();
        byte[] bytes = new byte[(length << 2) / 5 - padding];
        long value = 0L;
        int index = 0;
        for (int i = 0; i < length; ++i) {
            int code = encoded.charAt(i) - 32;
            value = value * 85L + (long)decodeTable[code];
            if ((i + 1) % 5 != 0) continue;
            for (int j = 0; j < 4; ++j) {
                int idx = index + 3 - j;
                if (idx < bytes.length) {
                    bytes[idx] = (byte)(value & 0xFFL);
                }
                value >>>= 8;
            }
            index += 4;
            value = 0L;
        }
        return bytes;
    }
}

