/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.compare;

import java.lang.reflect.Field;
import org.miaixz.bus.core.compare.FunctionCompare;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.StringKit;

public class FieldCompare<T>
extends FunctionCompare<T> {
    private static final long serialVersionUID = -1L;

    public FieldCompare(Class<T> beanClass, String fieldName) {
        this(FieldCompare.getNonNullField(beanClass, fieldName));
    }

    public FieldCompare(Field field) {
        this(true, true, field);
    }

    public FieldCompare(boolean nullGreater, boolean compareSelf, Field field) {
        super(nullGreater, compareSelf, (T bean) -> (Comparable)FieldKit.getFieldValue(bean, Assert.notNull(field, "Field must be not null!", new Object[0])));
    }

    private static Field getNonNullField(Class<?> beanClass, String fieldName) {
        Field field = FieldKit.getField(beanClass, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(StringKit.format("Field [{}] not found in Class [{}]", fieldName, beanClass.getName()));
        }
        return field;
    }
}

