/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.convert.CompositeConverter;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class ReferenceConverter
extends AbstractConverter {
    private static final long serialVersionUID = -1L;
    public static ReferenceConverter INSTANCE = new ReferenceConverter();

    @Override
    protected Reference<?> convertInternal(Class<?> targetClass, Object value) {
        Object targetValue = null;
        Type paramType = TypeKit.getTypeArgument(targetClass);
        if (!TypeKit.isUnknown(paramType)) {
            targetValue = CompositeConverter.getInstance().convert(paramType, value);
        }
        if (null == targetValue) {
            targetValue = value;
        }
        if (targetClass == WeakReference.class) {
            return new WeakReference<Object>(targetValue);
        }
        if (targetClass == SoftReference.class) {
            return new SoftReference<Object>(targetValue);
        }
        throw new UnsupportedOperationException(StringKit.format("Unsupport Reference type: {}", targetClass.getName()));
    }
}

