/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.XMLGregorianCalendar;
import org.miaixz.bus.core.center.map.concurrent.SafeConcurrentHashMap;
import org.miaixz.bus.core.convert.AtomicBooleanConverter;
import org.miaixz.bus.core.convert.AtomicIntegerArrayConverter;
import org.miaixz.bus.core.convert.AtomicLongArrayConverter;
import org.miaixz.bus.core.convert.AtomicReferenceConverter;
import org.miaixz.bus.core.convert.BooleanConverter;
import org.miaixz.bus.core.convert.CalendarConverter;
import org.miaixz.bus.core.convert.CharacterConverter;
import org.miaixz.bus.core.convert.CharsetConverter;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.convert.CurrencyConverter;
import org.miaixz.bus.core.convert.DurationConverter;
import org.miaixz.bus.core.convert.LocaleConverter;
import org.miaixz.bus.core.convert.OptConverter;
import org.miaixz.bus.core.convert.OptionalConverter;
import org.miaixz.bus.core.convert.PairConverter;
import org.miaixz.bus.core.convert.PathConverter;
import org.miaixz.bus.core.convert.PeriodConverter;
import org.miaixz.bus.core.convert.ReferenceConverter;
import org.miaixz.bus.core.convert.StackTraceElementConverter;
import org.miaixz.bus.core.convert.StringConverter;
import org.miaixz.bus.core.convert.TemporalAccessorConverter;
import org.miaixz.bus.core.convert.TimeZoneConverter;
import org.miaixz.bus.core.convert.TripleConverter;
import org.miaixz.bus.core.convert.TupleConverter;
import org.miaixz.bus.core.convert.URIConverter;
import org.miaixz.bus.core.convert.URLConverter;
import org.miaixz.bus.core.convert.UUIDConverter;
import org.miaixz.bus.core.convert.XMLGregorianCalendarConverter;
import org.miaixz.bus.core.convert.ZoneIdConverter;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.tuple.Pair;
import org.miaixz.bus.core.lang.tuple.Triplet;
import org.miaixz.bus.core.lang.tuple.Tuple;
import org.miaixz.bus.core.xyz.TypeKit;

public class RegisterConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = -1L;
    private Map<Class<?>, Converter> defaultConverterMap;
    private volatile Map<Type, Converter> customConverterMap;

    public RegisterConverter() {
        this.registerDefault();
    }

    public static RegisterConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, true);
        if (null != converter) {
            return converter.convert(targetType, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, targetType.getTypeName());
    }

    public Converter getConverter(Type type, boolean isCustomFirst) {
        Converter converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public Converter getDefaultConverter(Type type) {
        Class<?> key = null == type ? null : TypeKit.getClass(type);
        return null == this.defaultConverterMap || null == key ? null : this.defaultConverterMap.get(key);
    }

    public Converter getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter putCustom(Type type, Converter converter) {
        if (null == this.customConverterMap) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new SafeConcurrentHashMap<Type, Converter>();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    private void registerDefault() {
        this.defaultConverterMap = new SafeConcurrentHashMap(64);
        this.defaultConverterMap.put(Character.class, new CharacterConverter());
        this.defaultConverterMap.put(Boolean.class, new BooleanConverter());
        this.defaultConverterMap.put(AtomicBoolean.class, new AtomicBooleanConverter());
        this.defaultConverterMap.put(CharSequence.class, new StringConverter());
        this.defaultConverterMap.put(String.class, new StringConverter());
        this.defaultConverterMap.put(URI.class, new URIConverter());
        this.defaultConverterMap.put(URL.class, new URLConverter());
        this.defaultConverterMap.put(Calendar.class, new CalendarConverter());
        this.defaultConverterMap.put(XMLGregorianCalendar.class, new XMLGregorianCalendarConverter());
        this.defaultConverterMap.put(TemporalAccessor.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(Instant.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(LocalDateTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(LocalDate.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(LocalTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(ZonedDateTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(OffsetDateTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(OffsetTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(DayOfWeek.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(Month.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(MonthDay.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(Period.class, new PeriodConverter());
        this.defaultConverterMap.put(Duration.class, new DurationConverter());
        this.defaultConverterMap.put(WeakReference.class, ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put(SoftReference.class, ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put(AtomicReference.class, new AtomicReferenceConverter());
        this.defaultConverterMap.put(AtomicIntegerArray.class, new AtomicIntegerArrayConverter());
        this.defaultConverterMap.put(AtomicLongArray.class, new AtomicLongArrayConverter());
        this.defaultConverterMap.put(TimeZone.class, new TimeZoneConverter());
        this.defaultConverterMap.put(ZoneId.class, new ZoneIdConverter());
        this.defaultConverterMap.put(Locale.class, new LocaleConverter());
        this.defaultConverterMap.put(Charset.class, new CharsetConverter());
        this.defaultConverterMap.put(Path.class, new PathConverter());
        this.defaultConverterMap.put(Currency.class, new CurrencyConverter());
        this.defaultConverterMap.put(UUID.class, new UUIDConverter());
        this.defaultConverterMap.put(StackTraceElement.class, new StackTraceElementConverter());
        this.defaultConverterMap.put(java.util.Optional.class, new OptionalConverter());
        this.defaultConverterMap.put(Optional.class, new OptConverter());
        this.defaultConverterMap.put(Pair.class, PairConverter.INSTANCE);
        this.defaultConverterMap.put(Triplet.class, TripleConverter.INSTANCE);
        this.defaultConverterMap.put(Tuple.class, TupleConverter.INSTANCE);
    }

    private static class SingletonHolder {
        private static final RegisterConverter INSTANCE = new RegisterConverter();

        private SingletonHolder() {
        }
    }
}

