/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data;

import org.miaixz.bus.core.lang.EnumMap;
import org.miaixz.bus.core.xyz.StringKit;

public class Masking {
    public static String masking(CharSequence text, EnumMap.Masking masking) {
        if (StringKit.isBlank(text)) {
            return "";
        }
        String newText = String.valueOf(text);
        switch (masking) {
            case USER_ID: {
                newText = String.valueOf(Masking.userId());
                break;
            }
            case CHINESE_NAME: {
                newText = Masking.chineseName(String.valueOf(text));
                break;
            }
            case ID_CARD: {
                newText = Masking.idCardNum(String.valueOf(text), 1, 2);
                break;
            }
            case FIXED_PHONE: {
                newText = Masking.fixedPhone(String.valueOf(text));
                break;
            }
            case MOBILE_PHONE: {
                newText = Masking.mobilePhone(String.valueOf(text));
                break;
            }
            case ADDRESS: {
                newText = Masking.address(String.valueOf(text), 8);
                break;
            }
            case EMAIL: {
                newText = Masking.email(String.valueOf(text));
                break;
            }
            case PASSWORD: {
                newText = Masking.password(String.valueOf(text));
                break;
            }
            case CAR_LICENSE: {
                newText = Masking.carLicense(String.valueOf(text));
                break;
            }
            case BANK_CARD: {
                newText = Masking.bankCard(String.valueOf(text));
                break;
            }
            case IPV4: {
                newText = Masking.ipv4(String.valueOf(text));
                break;
            }
            case IPV6: {
                newText = Masking.ipv6(String.valueOf(text));
                break;
            }
            case FIRST_MASK: {
                newText = Masking.firstMask(String.valueOf(text));
                break;
            }
            case CLEAR_TO_EMPTY: {
                newText = Masking.clear();
                break;
            }
            case CLEAR_TO_NULL: {
                newText = Masking.clearToNull();
                break;
            }
        }
        return newText;
    }

    public static String clear() {
        return "";
    }

    public static String clearToNull() {
        return null;
    }

    public static Long userId() {
        return 0L;
    }

    public static String firstMask(String text) {
        if (StringKit.isBlank(text)) {
            return "";
        }
        return StringKit.hide(text, 1, text.length());
    }

    public static String chineseName(String fullName) {
        return Masking.firstMask(fullName);
    }

    public static String idCardNum(String idCardNum, int front, int end) {
        if (StringKit.isBlank(idCardNum)) {
            return "";
        }
        if (front + end > idCardNum.length()) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return StringKit.hide(idCardNum, front, idCardNum.length() - end);
    }

    public static String fixedPhone(String num) {
        if (StringKit.isBlank(num)) {
            return "";
        }
        return StringKit.hide(num, 4, num.length() - 2);
    }

    public static String mobilePhone(String num) {
        if (StringKit.isBlank(num)) {
            return "";
        }
        return StringKit.hide(num, 3, num.length() - 4);
    }

    public static String address(String address, int sensitiveSize) {
        if (StringKit.isBlank(address)) {
            return "";
        }
        int length = address.length();
        return StringKit.hide(address, length - sensitiveSize, length);
    }

    public static String email(String email) {
        if (StringKit.isBlank(email)) {
            return "";
        }
        int index = StringKit.indexOf(email, '@');
        if (index <= 1) {
            return email;
        }
        return StringKit.hide(email, 1, index);
    }

    public static String password(String password) {
        if (StringKit.isBlank(password)) {
            return "";
        }
        return StringKit.repeat('*', password.length());
    }

    public static String carLicense(String carLicense) {
        if (StringKit.isBlank(carLicense)) {
            return "";
        }
        if (carLicense.length() == 7) {
            carLicense = StringKit.hide(carLicense, 3, 6);
        } else if (carLicense.length() == 8) {
            carLicense = StringKit.hide(carLicense, 3, 7);
        }
        return carLicense;
    }

    public static String bankCard(String bankCardNo) {
        if (StringKit.isBlank(bankCardNo)) {
            return bankCardNo;
        }
        if ((bankCardNo = StringKit.cleanBlank(bankCardNo)).length() < 9) {
            return bankCardNo;
        }
        int length = bankCardNo.length();
        int endLength = length % 4 == 0 ? 4 : length % 4;
        int midLength = length - 4 - endLength;
        StringBuilder buf = new StringBuilder();
        buf.append(bankCardNo, 0, 4);
        for (int i = 0; i < midLength; ++i) {
            if (i % 4 == 0) {
                buf.append(' ');
            }
            buf.append('*');
        }
        buf.append(' ').append(bankCardNo, length - endLength, length);
        return buf.toString();
    }

    public static String ipv4(String ipv4) {
        return StringKit.subBefore((CharSequence)ipv4, '.', false) + ".*.*.*";
    }

    public static String ipv6(String ipv6) {
        return StringKit.subBefore((CharSequence)ipv6, ':', false) + ":*:*:*:*:*:*:*";
    }
}

