/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.miaixz.bus.core.center.iterator.ComputeIterator;
import org.miaixz.bus.core.io.ReaderWrapper;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class LineReader
extends ReaderWrapper
implements Iterable<String> {
    public LineReader(InputStream in, Charset charset) {
        this(IoKit.toReader(in, charset));
    }

    public LineReader(Reader reader) {
        super(IoKit.toBuffered(reader));
    }

    public String readLine() throws IOException {
        int c;
        StringBuilder text = null;
        boolean precedingBackslash = false;
        while ((c = this.read()) > 0) {
            if (null == text) {
                text = StringKit.builder(1024);
            }
            if (92 == c) {
                if (!precedingBackslash) {
                    precedingBackslash = true;
                    continue;
                }
                precedingBackslash = false;
            } else if (precedingBackslash) {
                if (CharKit.isBlankChar(c)) continue;
                precedingBackslash = false;
            } else if (10 == c) {
                int lastIndex = text.length() - 1;
                if (lastIndex < 0 || '\r' != text.charAt(lastIndex)) break;
                text.deleteCharAt(lastIndex);
                break;
            }
            text.append((char)c);
        }
        return StringKit.toStringOrNull(text);
    }

    @Override
    public Iterator<String> iterator() {
        return new ComputeIterator<String>(){

            @Override
            protected String computeNext() {
                try {
                    return LineReader.this.readLine();
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }
        };
    }
}

