/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.miaixz.bus.core.io.file.PathCopier;
import org.miaixz.bus.core.io.file.PathMover;
import org.miaixz.bus.core.io.file.PathRemover;
import org.miaixz.bus.core.io.resource.FileResource;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class PathResolve {
    public static Path of(String firstPath, String ... paths) {
        return Paths.get(firstPath, paths);
    }

    public static Path of(Path firstPath, Path ... paths) {
        if (ArrayKit.isEmpty(paths)) {
            return firstPath;
        }
        for (Path path : paths) {
            if (null == path) continue;
            firstPath = null == firstPath ? path : firstPath.resolve(path);
        }
        return firstPath;
    }

    public static boolean isDirEmpty(Path dirPath) {
        boolean bl;
        block8: {
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(dirPath);
            try {
                boolean bl2 = bl = !dirStream.iterator().hasNext();
                if (dirStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }
            dirStream.close();
        }
        return bl;
    }

    public static List<File> loopFiles(Path path, FileFilter fileFilter) {
        return PathResolve.loopFiles(path, -1, fileFilter);
    }

    public static List<File> loopFiles(Path path, int maxDepth, FileFilter fileFilter) {
        return PathResolve.loopFiles(path, maxDepth, false, fileFilter);
    }

    public static List<File> loopFiles(Path path, int maxDepth, boolean isFollowLinks, final FileFilter fileFilter) {
        final ArrayList<File> fileList = new ArrayList<File>();
        if (!PathResolve.exists(path, isFollowLinks)) {
            return fileList;
        }
        if (!PathResolve.isDirectory(path, isFollowLinks)) {
            File file = path.toFile();
            if (null == fileFilter || fileFilter.accept(file)) {
                fileList.add(file);
            }
            return fileList;
        }
        PathResolve.walkFiles(path, maxDepth, isFollowLinks, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                File file = path.toFile();
                if (null == fileFilter || fileFilter.accept(file)) {
                    fileList.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }

    public static void walkFiles(Path start, FileVisitor<? super Path> visitor) {
        PathResolve.walkFiles(start, -1, visitor);
    }

    public static void walkFiles(Path start, int maxDepth, FileVisitor<? super Path> visitor) {
        PathResolve.walkFiles(start, maxDepth, false, visitor);
    }

    public static void walkFiles(Path start, int maxDepth, boolean isFollowLinks, FileVisitor<? super Path> visitor) {
        if (maxDepth < 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        try {
            Files.walkFileTree(start, PathResolve.getFileVisitOption(isFollowLinks), maxDepth, visitor);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static void remove(Path path) throws InternalException {
        PathRemover.of(path).remove();
    }

    public static void clean(Path path) {
        PathRemover.of(path).clean();
    }

    public static Path copy(Resource src, Path target, CopyOption ... options) throws InternalException {
        Path path;
        block9: {
            Assert.notNull(src, "Source is null !", new Object[0]);
            if (src instanceof FileResource) {
                return PathResolve.copy(((FileResource)src).getFile().toPath(), target, options);
            }
            InputStream stream = src.getStream();
            try {
                path = PathResolve.copy(stream, target, options);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return path;
    }

    public static Path copy(InputStream src, Path target, CopyOption ... options) throws InternalException {
        Assert.notNull(target, "Destination File or directory is null !", new Object[0]);
        PathResolve.mkParentDirs(target);
        try {
            Files.copy(src, target, options);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return target;
    }

    public static long copy(Path src, OutputStream out) throws InternalException {
        Assert.notNull(src, "Source is null !", new Object[0]);
        try {
            return Files.copy(src, out);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static Path copy(Path src, Path target, CopyOption ... options) throws InternalException {
        return PathCopier.of(src, target, options).copy();
    }

    public static Path copyContent(Path src, Path target, CopyOption ... options) throws InternalException {
        return PathCopier.of(src, target, options).copyContent();
    }

    public static boolean isDirectory(Path path) {
        return PathResolve.isDirectory(path, false);
    }

    public static boolean isExistsAndNotDirectory(Path path, boolean isFollowLinks) {
        return PathResolve.exists(path, isFollowLinks) && !PathResolve.isDirectory(path, isFollowLinks);
    }

    public static boolean isDirectory(Path path, boolean isFollowLinks) {
        if (null == path) {
            return false;
        }
        return Files.isDirectory(path, PathResolve.getLinkOptions(isFollowLinks));
    }

    public static Path getPathEle(Path path, int index) {
        return PathResolve.subPath(path, index, index == -1 ? path.getNameCount() : index + 1);
    }

    public static Path getLastPathEle(Path path) {
        return PathResolve.getPathEle(path, path.getNameCount() - 1);
    }

    public static Path subPath(Path path, int fromIndex, int toIndex) {
        if (null == path) {
            return null;
        }
        int len = path.getNameCount();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return null;
        }
        return path.subpath(fromIndex, toIndex);
    }

    public static BasicFileAttributes getAttributes(Path path, boolean isFollowLinks) throws InternalException {
        if (null == path) {
            return null;
        }
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, PathResolve.getLinkOptions(isFollowLinks));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static BufferedInputStream getInputStream(Path path) throws InternalException {
        InputStream in;
        try {
            in = Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return IoKit.toBuffered(in);
    }

    public static BufferedReader getUtf8Reader(Path path) throws InternalException {
        return PathResolve.getReader(path, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static BufferedReader getReader(Path path, Charset charset) throws InternalException {
        return IoKit.toReader(PathResolve.getInputStream(path), charset);
    }

    public static byte[] readBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static BufferedOutputStream getOutputStream(Path path) throws InternalException {
        OutputStream in;
        try {
            in = Files.newOutputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return IoKit.toBuffered(in);
    }

    public static Path rename(Path path, String newName, boolean isOverride) {
        return PathResolve.move(path, path.resolveSibling(newName), isOverride);
    }

    public static Path move(Path src, Path target, boolean isOverride) {
        return PathMover.of(src, target, isOverride).move();
    }

    public static Path moveContent(Path src, Path target, boolean isOverride) {
        return PathMover.of(src, target, isOverride).moveContent();
    }

    public static boolean equals(Path file1, Path file2) throws InternalException {
        if (null == file1 || null == file2) {
            return null == file1 && null == file2;
        }
        boolean exists1 = PathResolve.exists(file1, false);
        boolean exists2 = PathResolve.exists(file2, false);
        if (exists1 && exists2) {
            return PathResolve.isSameFile(file1, file2);
        }
        return ObjectKit.equals(file1, file2);
    }

    public static boolean isSameFile(Path file1, Path file2) throws InternalException {
        try {
            return Files.isSameFile(file1, file2);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static boolean isFile(Path path, boolean isFollowLinks) {
        if (null == path) {
            return false;
        }
        return Files.isRegularFile(path, PathResolve.getLinkOptions(isFollowLinks));
    }

    public static boolean isSymlink(Path path) {
        return Files.isSymbolicLink(path);
    }

    public static boolean isOther(Path path) {
        return PathResolve.getAttributes(path, false).isOther();
    }

    public static boolean exists(Path path, boolean isFollowLinks) {
        if (null == path) {
            return false;
        }
        return Files.exists(path, PathResolve.getLinkOptions(isFollowLinks));
    }

    public static boolean isSub(Path parent, Path sub) {
        return PathResolve.toAbsNormal(sub).startsWith(PathResolve.toAbsNormal(parent));
    }

    public static Path toAbsNormal(Path path) {
        if (null == path) {
            return null;
        }
        return path.toAbsolutePath().normalize();
    }

    public static Path toRealPath(Path path) throws InternalException {
        if (null != path) {
            try {
                path = path.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        return path;
    }

    public static String getMimeType(Path file) {
        try {
            return Files.probeContentType(file);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public static Path mkdir(Path dir) {
        if (null != dir && !PathResolve.exists(dir, false)) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        return dir;
    }

    public static Path mkParentDirs(Path path) {
        return PathResolve.mkdir(path.getParent());
    }

    public static String getName(Path path) {
        if (null == path) {
            return null;
        }
        return path.getFileName().toString();
    }

    public static Path createTempFile(String prefix, String suffix, Path dir) throws InternalException {
        int exceptionsCount = 0;
        while (true) {
            try {
                if (null == dir) {
                    return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
                }
                return Files.createTempFile(PathResolve.mkdir(dir), prefix, suffix, new FileAttribute[0]);
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw new InternalException(ioex);
            }
            break;
        }
    }

    public static LinkOption[] getLinkOptions(boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        return linkOptionArray;
    }

    public static Set<FileVisitOption> getFileVisitOption(boolean isFollowLinks) {
        return isFollowLinks ? EnumSet.of(FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
    }
}

