/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import org.miaixz.bus.core.io.CharsetDetector;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Charset {
    public static final java.nio.charset.Charset DEFAULT = java.nio.charset.Charset.defaultCharset();
    public static final String DEFAULT_CHARSET = DEFAULT.displayName();
    public static final String DEFAULT_ISO_8859_1 = "ISO-8859-1";
    public static final java.nio.charset.Charset ISO_8859_1 = java.nio.charset.Charset.forName("ISO-8859-1");
    public static final String DEFAULT_US_ASCII = "US-ASCII";
    public static final java.nio.charset.Charset US_ASCII = java.nio.charset.Charset.forName("US-ASCII");
    public static final String DEFAULT_GBK = "GBK";
    public static final java.nio.charset.Charset GBK = java.nio.charset.Charset.forName("GBK");
    public static final String DEFAULT_GB_2312 = "GB2312";
    public static final java.nio.charset.Charset GB_2312 = java.nio.charset.Charset.forName("GB2312");
    public static final String DEFAULT_GB_18030 = "GB18030";
    public static final java.nio.charset.Charset GB_18030 = java.nio.charset.Charset.forName("GB18030");
    public static final String DEFAULT_UTF_8 = "UTF-8";
    public static final java.nio.charset.Charset UTF_8 = java.nio.charset.Charset.forName("UTF-8");
    public static final String DEFAULT_UTF_16 = "UTF-16";
    public static final java.nio.charset.Charset UTF_16 = java.nio.charset.Charset.forName("UTF-16");
    public static final String DEFAULT_UTF_16_BE = "UTF-16BE";
    public static final java.nio.charset.Charset UTF_16_BE = java.nio.charset.Charset.forName("UTF-16BE");
    public static final String DEFAULT_UTF_16_LE = "UTF-16LE";
    public static final java.nio.charset.Charset UTF_16_LE = java.nio.charset.Charset.forName("UTF-16LE");
    public static final String DEFAULT_UTF_32_BE = "UTF-32BE";
    public static final java.nio.charset.Charset UTF_32_BE = java.nio.charset.Charset.forName("UTF-32BE");
    public static final String DEFAULT_UTF_32_LE = "UTF-32LE";
    public static final java.nio.charset.Charset UTF_32_LE = java.nio.charset.Charset.forName("UTF-32LE");

    public static java.nio.charset.Charset charset(String charsetName) throws UnsupportedCharsetException {
        return StringKit.isBlank(charsetName) ? java.nio.charset.Charset.defaultCharset() : java.nio.charset.Charset.forName(charsetName);
    }

    public static java.nio.charset.Charset parse(String charsetName) {
        return Charset.parse(charsetName, java.nio.charset.Charset.defaultCharset());
    }

    public static java.nio.charset.Charset parse(String charsetName, java.nio.charset.Charset defaultCharset) {
        java.nio.charset.Charset result;
        if (StringKit.isBlank(charsetName)) {
            return defaultCharset;
        }
        try {
            result = java.nio.charset.Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            result = defaultCharset;
        }
        return result;
    }

    public static String convert(String source, String srcCharset, String destCharset) {
        return Charset.convert(source, java.nio.charset.Charset.forName(srcCharset), java.nio.charset.Charset.forName(destCharset));
    }

    public static String convert(String source, java.nio.charset.Charset srcCharset, java.nio.charset.Charset destCharset) {
        if (null == srcCharset) {
            srcCharset = ISO_8859_1;
        }
        if (null == destCharset) {
            destCharset = UTF_8;
        }
        if (StringKit.isBlank(source) || srcCharset.equals(destCharset)) {
            return source;
        }
        return new String(source.getBytes(srcCharset), destCharset);
    }

    public static File convert(File file, java.nio.charset.Charset srcCharset, java.nio.charset.Charset destCharset) {
        return FileKit.writeString(FileKit.readString(file, srcCharset), file, destCharset);
    }

    public static String systemCharsetName() {
        return Charset.systemCharset().name();
    }

    public static java.nio.charset.Charset systemCharset() {
        return FileKit.isWindows() ? GBK : Charset.defaultCharset();
    }

    public static String defaultCharsetName() {
        return Charset.defaultCharset().name();
    }

    public static java.nio.charset.Charset defaultCharset() {
        return java.nio.charset.Charset.defaultCharset();
    }

    public static java.nio.charset.Charset detect(InputStream in, java.nio.charset.Charset ... charsets) {
        return CharsetDetector.detect(in, charsets);
    }

    public static java.nio.charset.Charset detect(int bufferSize, InputStream in, java.nio.charset.Charset ... charsets) {
        return CharsetDetector.detect(bufferSize, in, charsets);
    }

    public static CharsetEncoder newEncoder(java.nio.charset.Charset charset, CodingErrorAction action) {
        return Assert.notNull(charset).newEncoder().onMalformedInput(action).onUnmappableCharacter(action);
    }

    public static CharsetDecoder newDecoder(java.nio.charset.Charset charset, CodingErrorAction action) {
        return Assert.notNull(charset).newDecoder().onMalformedInput(action).onUnmappableCharacter(action).replaceWith("?");
    }
}

