/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.pool.partition;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.miaixz.bus.core.lang.pool.ObjectFactory;
import org.miaixz.bus.core.lang.pool.ObjectPool;
import org.miaixz.bus.core.lang.pool.Poolable;
import org.miaixz.bus.core.lang.pool.partition.PartitionPoolConfig;
import org.miaixz.bus.core.lang.pool.partition.PoolPartition;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ThreadKit;

public class PartitionObjectPool<T>
implements ObjectPool<T> {
    private static final long serialVersionUID = -1L;
    private final PartitionPoolConfig config;
    private final PoolPartition<T>[] partitions;
    private boolean closed;

    public PartitionObjectPool(PartitionPoolConfig config, ObjectFactory<T> factory) {
        this.config = config;
        int partitionSize = config.getPartitionSize();
        this.partitions = new PoolPartition[partitionSize];
        for (int i = 0; i < partitionSize; ++i) {
            this.partitions[i] = new PoolPartition<T>(config, this.createBlockingQueue(config), factory);
        }
    }

    @Override
    public int getTotal() {
        int size = 0;
        for (PoolPartition<T> subPool : this.partitions) {
            size += subPool.getTotal();
        }
        return size;
    }

    @Override
    public int getIdleCount() {
        int size = 0;
        for (PoolPartition<T> subPool : this.partitions) {
            size += subPool.getIdleCount();
        }
        return size;
    }

    @Override
    public int getActiveCount() {
        int size = 0;
        for (PoolPartition<T> subPool : this.partitions) {
            size += subPool.getActiveCount();
        }
        return size;
    }

    @Override
    public Poolable<T> borrowObject() {
        this.checkClosed();
        return this.partitions[this.getPartitionIndex(this.config)].borrowObject();
    }

    @Override
    public PartitionObjectPool<T> returnObject(Poolable<T> obj) {
        this.checkClosed();
        this.partitions[this.getPartitionIndex(this.config)].returnObject((Poolable)obj);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        IoKit.closeQuietly(this.partitions);
    }

    protected BlockingQueue<Poolable<T>> createBlockingQueue(PartitionPoolConfig poolConfig) {
        return new ArrayBlockingQueue<Poolable<T>>(poolConfig.getMaxSize());
    }

    protected int getPartitionIndex(PartitionPoolConfig poolConfig) {
        return (int)(ThreadKit.currentThreadId() % (long)poolConfig.getPartitionSize());
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Object Pool is closed!");
        }
    }
}

