/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.miaixz.bus.core.center.iterator.EnumerationIterator;
import org.miaixz.bus.core.io.resource.JarResource;
import org.miaixz.bus.core.lang.Charset;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ExceptionKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ClassScanner
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final String packageName;
    private final String packageNameWithDot;
    private final String packageDirName;
    private final String packagePath;
    private final Predicate<Class<?>> classPredicate;
    private final java.nio.charset.Charset charset;
    private final Set<Class<?>> classes = new HashSet();
    private final Set<String> classesOfLoadError = new HashSet<String>();
    private ClassLoader classLoader;
    private boolean initialize;
    private boolean ignoreLoadError = false;

    public ClassScanner() {
        this(null);
    }

    public ClassScanner(String packageName) {
        this(packageName, null);
    }

    public ClassScanner(String packageName, Predicate<Class<?>> classPredicate) {
        this(packageName, classPredicate, Charset.UTF_8);
    }

    public ClassScanner(String packageName, Predicate<Class<?>> classPredicate, java.nio.charset.Charset charset) {
        this.packageName = packageName = StringKit.emptyIfNull(packageName);
        this.packageNameWithDot = StringKit.addSuffixIfNot(packageName, ".");
        this.packageDirName = packageName.replace('.', File.separatorChar);
        this.packagePath = packageName.replace('.', '/');
        this.classPredicate = classPredicate;
        this.charset = charset;
    }

    public static Set<Class<?>> scanAllPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanAllPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScanner.scanPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanAllPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanAllPackage(packageName, clazz -> superClass.isAssignableFrom((Class<?>)clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScanner.scanPackage(packageName, clazz -> superClass.isAssignableFrom((Class<?>)clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanAllPackage() {
        return ClassScanner.scanAllPackage("", null);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanAllPackage(String packageName, Predicate<Class<?>> classFilter) {
        return new ClassScanner(packageName, classFilter).scan(true);
    }

    public static Set<Class<?>> scanPackage(String packageName, Predicate<Class<?>> classFilter) {
        return new ClassScanner(packageName, classFilter).scan();
    }

    public Set<Class<?>> scan() {
        return this.scan(false);
    }

    public Set<Class<?>> scan(boolean forceScanJavaClassPaths) {
        this.classes.clear();
        this.classesOfLoadError.clear();
        for (URL url : ResourceKit.getResourceUrlIter(this.packagePath, this.classLoader)) {
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(UrlDecoder.decode(url.getFile(), this.charset)), null);
                    break;
                }
                case "jar": {
                    this.scanJar(new JarResource(url).getJarFile());
                }
            }
        }
        if (forceScanJavaClassPaths || CollKit.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    public Set<String> getClassesOfLoadError() {
        return Collections.unmodifiableSet(this.classesOfLoadError);
    }

    public void setIgnoreLoadError(boolean ignoreLoadError) {
        this.ignoreLoadError = ignoreLoadError;
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void scanJavaClassPaths() {
        String[] javaClassPaths;
        for (String classPath : javaClassPaths = Keys.getJavaClassPaths()) {
            classPath = UrlDecoder.decode(classPath, Charset.defaultCharset());
            this.scanFile(new File(classPath), null);
        }
    }

    private void scanFile(File file, String rootDir) {
        File[] files;
        if (file.isFile()) {
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(".class")) {
                String className = fileName.substring(rootDir.length(), fileName.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(className);
            } else if (fileName.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }
        } else if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File subFile : files) {
                this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(JarFile jar) {
        try {
            for (JarEntry entry : new EnumerationIterator<JarEntry>(jar.entries())) {
                String name = StringKit.removePrefix(entry.getName(), "/");
                if (!StringKit.isEmpty(this.packagePath) && !name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(0, name.length() - 6).replace('/', '.');
                this.addIfAccept(this.loadClass(className));
            }
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(jar);
            throw throwable;
        }
        IoKit.closeQuietly(jar);
    }

    protected Class<?> loadClass(String className) {
        ClassLoader loader = this.classLoader;
        if (null == loader) {
            this.classLoader = loader = ClassKit.getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, this.initialize, loader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
        }
        catch (Exception e) {
            this.classesOfLoadError.add(className);
        }
        catch (Throwable e) {
            if (!this.ignoreLoadError) {
                throw ExceptionKit.wrapRuntime(e);
            }
            this.classesOfLoadError.add(className);
        }
        return clazz;
    }

    private void addIfAccept(String className) {
        int packageLen;
        if (StringKit.isBlank(className)) {
            return;
        }
        int classLen = className.length();
        if (classLen == (packageLen = this.packageName.length())) {
            if (className.equals(this.packageName)) {
                this.addIfAccept(this.loadClass(className));
            }
        } else if (classLen > packageLen && (".".equals(this.packageNameWithDot) || className.startsWith(this.packageNameWithDot))) {
            this.addIfAccept(this.loadClass(className));
        }
    }

    private void addIfAccept(Class<?> clazz) {
        Predicate<Class<?>> classFilter;
        if (null != clazz && ((classFilter = this.classPredicate) == null || classFilter.test(clazz))) {
            this.classes.add(clazz);
        }
    }

    private String subPathBeforePackage(File file) {
        String filePath = file.getAbsolutePath();
        if (StringKit.isNotEmpty(this.packageDirName)) {
            filePath = StringKit.subBefore((CharSequence)filePath, this.packageDirName, true);
        }
        return StringKit.addSuffixIfNot(filePath, File.separator);
    }
}

