/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.creator;

import java.lang.invoke.MethodHandle;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.reflect.creator.ObjectCreator;
import org.miaixz.bus.core.lang.reflect.method.MethodInvoker;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.LookupKit;

public class DefaultObjectCreator<T>
implements ObjectCreator<T> {
    final MethodHandle constructor;
    final Object[] params;

    public DefaultObjectCreator(Class<T> clazz, Object ... params) {
        Class<?>[] paramTypes = ClassKit.getClasses(params);
        this.constructor = LookupKit.findConstructor(clazz, paramTypes);
        Assert.notNull(this.constructor, "Constructor not found!", new Object[0]);
        this.params = params;
    }

    public static <T> DefaultObjectCreator<T> of(String fullClassName) {
        return DefaultObjectCreator.of(ClassKit.loadClass(fullClassName), new Object[0]);
    }

    public static <T> DefaultObjectCreator<T> of(Class<T> clazz, Object ... params) {
        return new DefaultObjectCreator<T>(clazz, params);
    }

    @Override
    public T create() {
        return MethodInvoker.invokeHandle(this.constructor, this.params);
    }
}

