/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.thread.threadlocal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.miaixz.bus.core.lang.thread.threadlocal.ThreadLocalMap;

public class FastThreadLocal<V> {
    private final int index = ThreadLocalMap.nextVariableIndex();

    public static int size() {
        ThreadLocalMap threadLocalMap = ThreadLocalMap.getIfSet();
        if (threadLocalMap == null) {
            return 0;
        }
        return threadLocalMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAll() {
        ThreadLocalMap threadLocalMap = ThreadLocalMap.getIfSet();
        if (threadLocalMap == null) {
            return;
        }
        try {
            Object v = threadLocalMap.indexedVariable(ThreadLocalMap.VARIABLES_TO_REMOVE_INDEX);
            if (v != null && v != ThreadLocalMap.UNSET) {
                FastThreadLocal[] variablesToRemoveArray;
                Set variablesToRemove = (Set)v;
                for (FastThreadLocal tlv : variablesToRemoveArray = variablesToRemove.toArray(new FastThreadLocal[variablesToRemove.size()])) {
                    tlv.remove(threadLocalMap);
                }
            }
        }
        finally {
            ThreadLocalMap.remove();
        }
    }

    public static void destroy() {
        ThreadLocalMap.destroy();
    }

    private static void addToVariablesToRemove(ThreadLocalMap threadLocalMap, FastThreadLocal<?> variable) {
        Set variablesToRemove;
        Object v = threadLocalMap.indexedVariable(ThreadLocalMap.VARIABLES_TO_REMOVE_INDEX);
        if (v == ThreadLocalMap.UNSET || v == null) {
            variablesToRemove = Collections.newSetFromMap(new IdentityHashMap());
            threadLocalMap.setIndexedVariable(ThreadLocalMap.VARIABLES_TO_REMOVE_INDEX, variablesToRemove);
        } else {
            variablesToRemove = (Set)v;
        }
        variablesToRemove.add(variable);
    }

    private static void removeFromVariablesToRemove(ThreadLocalMap threadLocalMap, FastThreadLocal<?> variable) {
        Object v = threadLocalMap.indexedVariable(ThreadLocalMap.VARIABLES_TO_REMOVE_INDEX);
        if (v == ThreadLocalMap.UNSET || v == null) {
            return;
        }
        Set variablesToRemove = (Set)v;
        variablesToRemove.remove(variable);
    }

    public final V get() {
        ThreadLocalMap threadLocalMap = ThreadLocalMap.get();
        Object v = threadLocalMap.indexedVariable(this.index);
        if (v != ThreadLocalMap.UNSET) {
            return (V)v;
        }
        return this.initialize(threadLocalMap);
    }

    public final void set(V value) {
        if (value == null || value == ThreadLocalMap.UNSET) {
            this.remove();
        } else {
            ThreadLocalMap threadLocalMap = ThreadLocalMap.get();
            if (threadLocalMap.setIndexedVariable(this.index, value)) {
                FastThreadLocal.addToVariablesToRemove(threadLocalMap, this);
            }
        }
    }

    public final void remove() {
        this.remove(ThreadLocalMap.getIfSet());
    }

    public final void remove(ThreadLocalMap threadLocalMap) {
        if (threadLocalMap == null) {
            return;
        }
        Object v = threadLocalMap.removeIndexedVariable(this.index);
        FastThreadLocal.removeFromVariablesToRemove(threadLocalMap, this);
        if (v != ThreadLocalMap.UNSET) {
            try {
                this.onRemoval(v);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected V initialValue() {
        return null;
    }

    protected void onRemoval(V value) {
    }

    private V initialize(ThreadLocalMap threadLocalMap) {
        V v;
        try {
            v = this.initialValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        threadLocalMap.setIndexedVariable(this.index, v);
        FastThreadLocal.addToVariablesToRemove(threadLocalMap, this);
        return v;
    }
}

