/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.tuple;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.miaixz.bus.core.center.iterator.ArrayIterator;
import org.miaixz.bus.core.lang.exception.CloneException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ListKit;

public class Tuple
implements Iterable<Object>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1L;
    private final Object[] members;
    private int hashCode;
    private boolean cacheHash;

    public Tuple(Object ... members) {
        this.members = members;
    }

    public static Tuple of(Object ... members) {
        return new Tuple(members);
    }

    public <T> T get(int index) {
        return (T)this.members[index];
    }

    public Object[] getMembers() {
        return this.members;
    }

    public final List<Object> toList() {
        return ListKit.of(this.members);
    }

    public Tuple setCacheHash(boolean cacheHash) {
        this.cacheHash = cacheHash;
        return this;
    }

    public int size() {
        return this.members.length;
    }

    public boolean contains(Object value) {
        return ArrayKit.contains(this.members, value);
    }

    public final Stream<Object> stream() {
        return Arrays.stream(this.members);
    }

    public final Stream<Object> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    public final Tuple sub(int start, int end) {
        return new Tuple(ArrayKit.sub(this.members, start, end));
    }

    public int hashCode() {
        if (this.cacheHash && 0 != this.hashCode) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.members);
        if (this.cacheHash) {
            this.hashCode = result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return false != Arrays.deepEquals(this.members, other.members);
    }

    public String toString() {
        return Arrays.toString(this.members);
    }

    @Override
    public Iterator<Object> iterator() {
        return new ArrayIterator<Object>(this.members);
    }

    @Override
    public final Spliterator<Object> spliterator() {
        return Spliterators.spliterator(this.members, 16);
    }

    public Tuple clone() {
        try {
            return (Tuple)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }
}

