/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.tree;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.tree.Node;
import org.miaixz.bus.core.tree.NodeConfig;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TreeKit;

public class MapTree<T>
extends LinkedHashMap<String, Object>
implements Node<T> {
    private static final long serialVersionUID = -1L;
    private final NodeConfig nodeConfig;
    private MapTree<T> parent;

    public MapTree() {
        this((NodeConfig)null);
    }

    public MapTree(NodeConfig nodeConfig) {
        this.nodeConfig = ObjectKit.defaultIfNull(nodeConfig, NodeConfig.DEFAULT_CONFIG);
    }

    private static void printTree(MapTree<?> tree, PrintWriter writer, int intent) {
        writer.println(StringKit.format("{}{}[{}]", StringKit.repeat(' ', intent), tree.getName(), tree.getId()));
        writer.flush();
        List<MapTree<?>> children = tree.getChildren();
        if (CollKit.isNotEmpty(children)) {
            for (MapTree<?> child : children) {
                MapTree.printTree(child, writer, intent + 2);
            }
        }
    }

    public NodeConfig getConfig() {
        return this.nodeConfig;
    }

    public MapTree<T> getParent() {
        return this.parent;
    }

    public MapTree<T> setParent(MapTree<T> parent) {
        this.parent = parent;
        if (null != parent) {
            this.setParentId((Object)parent.getId());
        }
        return this;
    }

    public MapTree<T> getNode(T id) {
        return TreeKit.getNode(this, id);
    }

    public List<CharSequence> getParentsName(T id, boolean includeCurrentNode) {
        return TreeKit.getParentsName(this.getNode(id), includeCurrentNode);
    }

    public List<CharSequence> getParentsName(boolean includeCurrentNode) {
        return TreeKit.getParentsName(this, includeCurrentNode);
    }

    @Override
    public T getId() {
        return (T)this.get(this.nodeConfig.getIdKey());
    }

    @Override
    public MapTree<T> setId(T id) {
        this.put(this.nodeConfig.getIdKey(), id);
        return this;
    }

    @Override
    public T getParentId() {
        return (T)this.get(this.nodeConfig.getParentIdKey());
    }

    @Override
    public MapTree<T> setParentId(T parentId) {
        this.put(this.nodeConfig.getParentIdKey(), parentId);
        return this;
    }

    @Override
    public CharSequence getName() {
        return (CharSequence)this.get(this.nodeConfig.getNameKey());
    }

    @Override
    public MapTree<T> setName(CharSequence name) {
        this.put(this.nodeConfig.getNameKey(), name);
        return this;
    }

    @Override
    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.nodeConfig.getWeightKey());
    }

    @Override
    public MapTree<T> setWeight(Comparable<?> weight) {
        this.put(this.nodeConfig.getWeightKey(), weight);
        return this;
    }

    public List<MapTree<T>> getChildren() {
        return (List)this.get(this.nodeConfig.getChildrenKey());
    }

    public MapTree<T> setChildren(List<MapTree<T>> children) {
        if (null == children) {
            this.remove(this.nodeConfig.getChildrenKey());
        }
        this.put(this.nodeConfig.getChildrenKey(), children);
        return this;
    }

    public boolean hasChild() {
        return CollKit.isNotEmpty(this.getChildren());
    }

    public void walk(Consumer<MapTree<T>> consumer) {
        this.walk(consumer, false);
    }

    public void walk(Consumer<MapTree<T>> consumer, boolean broadFirst) {
        if (broadFirst) {
            LinkedList<MapTree> queue = new LinkedList<MapTree>();
            queue.offer(this);
            while (!queue.isEmpty()) {
                MapTree node = (MapTree)queue.poll();
                consumer.accept(node);
                List<MapTree<MapTree>> children = node.getChildren();
                if (!CollKit.isNotEmpty(children)) continue;
                children.forEach(queue::offer);
            }
        } else {
            Stack<MapTree> stack = new Stack<MapTree>();
            stack.add(this);
            while (!stack.isEmpty()) {
                MapTree node = (MapTree)stack.pop();
                consumer.accept(node);
                List<MapTree<MapTree>> children = node.getChildren();
                if (!CollKit.isNotEmpty(children)) continue;
                children.forEach(stack::push);
            }
        }
    }

    public MapTree<T> filterNew(Predicate<MapTree<T>> predicate) {
        return this.cloneTree().filter(predicate);
    }

    public MapTree<T> filter(Predicate<MapTree<T>> predicate) {
        if (null == predicate || predicate.test(this)) {
            return this;
        }
        List<MapTree<T>> children = this.getChildren();
        if (CollKit.isNotEmpty(children)) {
            ArrayList<MapTree<T>> filteredChildren = new ArrayList<MapTree<T>>(children.size());
            for (MapTree<MapTree<MapTree>> mapTree : children) {
                MapTree<T> filteredChild = mapTree.filter(predicate);
                if (null == filteredChild) continue;
                filteredChildren.add(filteredChild);
            }
            if (CollKit.isNotEmpty(filteredChildren)) {
                return this.setChildren(filteredChildren);
            }
            this.setChildren(null);
        }
        return null;
    }

    @SafeVarargs
    public final MapTree<T> addChildren(MapTree<T> ... children) {
        if (ArrayKit.isNotEmpty(children)) {
            List<MapTree<T>> childrenList = this.getChildren();
            if (null == childrenList) {
                childrenList = new ArrayList<MapTree<T>>();
                this.setChildren(childrenList);
            }
            for (MapTree<T> child : children) {
                child.setParent(this);
                childrenList.add(child);
            }
        }
        return this;
    }

    public void putExtra(String key, Object value) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(key, value);
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        MapTree.printTree(this, new PrintWriter(stringWriter), 0);
        return stringWriter.toString();
    }

    public MapTree<T> cloneTree() {
        MapTree result = ObjectKit.clone(this);
        result.setChildren(this.cloneChildren());
        return result;
    }

    private List<MapTree<T>> cloneChildren() {
        List<MapTree<MapTree>> children = this.getChildren();
        if (null == children) {
            return null;
        }
        ArrayList newChildren = new ArrayList(children.size());
        children.forEach((? super T t) -> newChildren.add(t.cloneTree()));
        return newChildren;
    }
}

