/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.Set;
import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.SetKit;
import org.miaixz.bus.core.xyz.StringKit;

public class BooleanKit {
    private static final Set<String> TRUE_SET = SetKit.of(Normal.TRUE_ARRAY);
    private static final Set<String> FALSE_SET = SetKit.of(Normal.FALSE_ARRAY);

    public static Boolean negate(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static boolean isFalse(Boolean bool) {
        return Boolean.FALSE.equals(bool);
    }

    public static boolean negate(boolean bool) {
        return !bool;
    }

    public static boolean toBoolean(String valueStr) {
        if (StringKit.isNotBlank(valueStr)) {
            return TRUE_SET.contains(valueStr.trim().toLowerCase());
        }
        return false;
    }

    public static Boolean toBooleanObject(String valueStr) {
        if (StringKit.isNotBlank(valueStr)) {
            if (TRUE_SET.contains(valueStr = valueStr.trim().toLowerCase())) {
                return Boolean.TRUE;
            }
            if (FALSE_SET.contains(valueStr)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Integer toInteger(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static char toChar(boolean value) {
        return (char)BooleanKit.toInt(value);
    }

    public static Character toCharacter(boolean value) {
        return Character.valueOf(BooleanKit.toChar(value));
    }

    public static byte toByte(boolean value) {
        return (byte)BooleanKit.toInt(value);
    }

    public static Byte toByteObject(boolean value) {
        return BooleanKit.toByte(value);
    }

    public static long toLong(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static Long toLongObject(boolean value) {
        return BooleanKit.toLong(value);
    }

    public static short toShort(boolean value) {
        return (short)BooleanKit.toInt(value);
    }

    public static Short toShortObject(boolean value) {
        return BooleanKit.toShort(value);
    }

    public static float toFloat(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static Float toFloatObject(boolean value) {
        return Float.valueOf(BooleanKit.toFloat(value));
    }

    public static double toDouble(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static Double toDoubleObject(boolean value) {
        return BooleanKit.toDouble(value);
    }

    public static String toStringTrueFalse(boolean bool) {
        return BooleanKit.toString(bool, "true", "false");
    }

    public static String toStringOnOff(boolean bool) {
        return BooleanKit.toString(bool, "on", "off");
    }

    public static String toStringYesNo(boolean bool) {
        return BooleanKit.toString(bool, "yes", "no");
    }

    public static String toString(boolean bool, String trueString, String falseString) {
        return bool ? trueString : falseString;
    }

    public static String toString(Boolean bool, String trueString, String falseString, String nullString) {
        if (bool == null) {
            return nullString;
        }
        return bool != false ? trueString : falseString;
    }

    public static boolean and(boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : array) {
            if (element) continue;
            return false;
        }
        return true;
    }

    public static Boolean andOfWrap(Boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (Boolean b : array) {
            if (BooleanKit.isTrue(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean or(boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : array) {
            if (!element) continue;
            return true;
        }
        return false;
    }

    public static Boolean orOfWrap(Boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (Boolean b : array) {
            if (!BooleanKit.isTrue(b)) continue;
            return true;
        }
        return false;
    }

    public static boolean xor(boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty");
        }
        boolean result = false;
        for (boolean element : array) {
            result ^= element;
        }
        return result;
    }

    public static Boolean xorOfWrap(Boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean result = false;
        for (Boolean element : array) {
            result ^= element.booleanValue();
        }
        return result;
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }
}

