/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.SerializeKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ObjectKit {
    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 instanceof Number && obj2 instanceof Number) {
            return MathKit.equals((Number)obj1, (Number)obj2);
        }
        if (ArrayKit.isArray(obj1) && ArrayKit.isArray(obj2)) {
            return ArrayKit.equals(obj1, obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    public static boolean notEquals(Object obj1, Object obj2) {
        return !ObjectKit.equals(obj1, obj2);
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        int count = 0;
        if (obj instanceof Iterator || obj instanceof Iterable) {
            Iterator iter;
            Iterator iterator = iter = obj instanceof Iterator ? (Iterator)obj : ((Iterable)obj).iterator();
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).containsValue(element);
        }
        if (obj instanceof Iterator || obj instanceof Iterable) {
            Iterator iter;
            Iterator iterator = iter = obj instanceof Iterator ? (Iterator)obj : ((Iterable)obj).iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ObjectKit.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!ObjectKit.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (ArrayKit.isArray(obj)) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!ObjectKit.equals(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StringKit.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Collection) {
            return CollKit.isEmpty((Collection)obj);
        }
        if (obj instanceof Map) {
            return MapKit.isEmpty((Map)obj);
        }
        if (obj instanceof Iterable) {
            return IteratorKit.isEmpty((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return IteratorKit.isEmpty((Iterator)obj);
        }
        if (ArrayKit.isArray(obj)) {
            return ArrayKit.isEmpty(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !ObjectKit.isEmpty(obj);
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return ObjectKit.isNull(object) ? defaultValue : object;
    }

    public static <T> T defaultIfNull(T source, Supplier<? extends T> defaultSupplier) {
        if (ObjectKit.isNotNull(source)) {
            return source;
        }
        return defaultSupplier.get();
    }

    public static <T, R> R defaultIfNull(T source, Function<? super T, ? extends R> handler, Supplier<? extends R> defaultSupplier) {
        if (ObjectKit.isNotNull(source)) {
            return handler.apply(source);
        }
        return defaultSupplier.get();
    }

    public static <T, R> R apply(T source, Function<T, R> handler) {
        return ObjectKit.defaultIfNull(source, handler, null);
    }

    public static <T> void accept(T source, Consumer<T> consumer) {
        if (null != source) {
            consumer.accept(source);
        }
    }

    public static <T, R> R defaultIfNull(T source, Function<? super T, ? extends R> handler, R defaultValue) {
        return ObjectKit.isNull(source) ? defaultValue : handler.apply(source);
    }

    public static <T> T clone(T obj) {
        T result = ArrayKit.clone(obj);
        if (null != result) {
            return result;
        }
        if (obj instanceof Cloneable) {
            try {
                return MethodKit.invoke(obj, "clone", new Object[0]);
            }
            catch (InternalException e) {
                if (e.getCause() instanceof IllegalAccessException) {
                    return ObjectKit.cloneByStream(obj);
                }
                throw e;
            }
        }
        return ObjectKit.cloneByStream(obj);
    }

    public static <T> T cloneIfPossible(T obj) {
        Object clone = null;
        try {
            clone = ObjectKit.clone(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)(clone == null ? obj : clone);
    }

    public static <T> T cloneByStream(T obj) {
        return SerializeKit.clone(obj);
    }

    public static boolean isBasicType(Object object) {
        if (null == object) {
            return false;
        }
        return ClassKit.isBasicType(object.getClass());
    }

    public static boolean isValidIfNumber(Object obj) {
        if (obj instanceof Number) {
            return MathKit.isValidNumber((Number)obj);
        }
        return true;
    }

    public static Class<?> getTypeArgument(Object obj) {
        return ObjectKit.getTypeArgument(obj, 0);
    }

    public static Class<?> getTypeArgument(Object obj, int index) {
        return ClassKit.getTypeArgument(obj.getClass(), index);
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return "null";
        }
        if (obj instanceof Map) {
            return obj.toString();
        }
        return Convert.toString(obj);
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (null == o1 || null == o2) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return ArrayKit.arrayEquals(o1, o2);
        }
        return false;
    }
}

