/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.culture.en.Various;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.selector.WeightObject;
import org.miaixz.bus.core.lang.selector.WeightRandomSelector;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.StringKit;

public class RandomKit {
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        return null == seed ? new SecureRandom() : new SecureRandom(seed);
    }

    public static SecureRandom getSecureRandom() {
        return RandomKit.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return RandomKit.createSecureRandom(seed);
    }

    public static SecureRandom getSHA1PRNGRandom(byte[] seed) {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalException(e);
        }
        if (null != seed) {
            random.setSeed(seed);
        }
        return random;
    }

    public static SecureRandom getSecureRandomStrong() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalException(e);
        }
    }

    public static Random getRandom(boolean isSecure) {
        return isSecure ? RandomKit.getSecureRandom() : RandomKit.getRandom();
    }

    public static boolean randomBoolean() {
        return 0 == RandomKit.randomInt(2);
    }

    public static byte[] randomBytes(int length) {
        return RandomKit.randomBytes(length, RandomKit.getRandom());
    }

    public static byte[] randomBytes(int length, Random random) {
        if (null == random) {
            random = RandomKit.getRandom();
        }
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public static char randomChinese() {
        return (char)RandomKit.randomInt(19968, 40959);
    }

    public static int randomInt() {
        return RandomKit.getRandom().nextInt();
    }

    public static int randomInt(int limitExclude) {
        return RandomKit.getRandom().nextInt(limitExclude);
    }

    public static int randomInt(int minInclude, int maxExclude) {
        return RandomKit.randomInt(minInclude, maxExclude, true, false);
    }

    public static int randomInt(int min, int max, boolean includeMin, boolean includeMax) {
        if (!includeMin) {
            ++min;
        }
        if (includeMax) {
            ++max;
        }
        return RandomKit.getRandom().nextInt(min, max);
    }

    public static int[] randomInts(int length) {
        int[] range = MathKit.range(length);
        for (int i = 0; i < length; ++i) {
            int random = RandomKit.randomInt(i, length);
            ArrayKit.swap(range, i, random);
        }
        return range;
    }

    public static long randomLong() {
        return RandomKit.getRandom().nextLong();
    }

    public static long randomLong(long limitExclude) {
        return RandomKit.getRandom().nextLong(limitExclude);
    }

    public static long randomLong(long minInclude, long maxExclude) {
        return RandomKit.randomLong(minInclude, maxExclude, true, false);
    }

    public static long randomLong(long min, long max, boolean includeMin, boolean includeMax) {
        if (!includeMin) {
            ++min;
        }
        if (includeMax) {
            ++max;
        }
        return RandomKit.getRandom().nextLong(min, max);
    }

    public static float randomFloat() {
        return RandomKit.getRandom().nextFloat();
    }

    public static float randomFloat(float limitExclude) {
        return RandomKit.randomFloat(0.0f, limitExclude);
    }

    public static float randomFloat(float minInclude, float maxExclude) {
        if (minInclude == maxExclude) {
            return minInclude;
        }
        return minInclude + (maxExclude - minInclude) * RandomKit.getRandom().nextFloat();
    }

    public static double randomDouble(double minInclude, double maxExclude) {
        return RandomKit.getRandom().nextDouble(minInclude, maxExclude);
    }

    public static double randomDouble(double minInclude, double maxExclude, int scale, RoundingMode roundingMode) {
        return MathKit.round(RandomKit.randomDouble(minInclude, maxExclude), scale, roundingMode).doubleValue();
    }

    public static double randomDouble() {
        return RandomKit.getRandom().nextDouble();
    }

    public static double randomDouble(int scale, RoundingMode roundingMode) {
        return MathKit.round(RandomKit.randomDouble(), scale, roundingMode).doubleValue();
    }

    public static double randomDouble(double limit) {
        return RandomKit.getRandom().nextDouble(limit);
    }

    public static double randomDouble(double limit, int scale, RoundingMode roundingMode) {
        return MathKit.round(RandomKit.randomDouble(limit), scale, roundingMode).doubleValue();
    }

    public static BigDecimal randomBigDecimal() {
        return MathKit.toBigDecimal(RandomKit.getRandom().nextDouble());
    }

    public static BigDecimal randomBigDecimal(BigDecimal limitExclude) {
        return MathKit.toBigDecimal(RandomKit.getRandom().nextDouble(limitExclude.doubleValue()));
    }

    public static BigDecimal randomBigDecimal(BigDecimal minInclude, BigDecimal maxExclude) {
        return MathKit.toBigDecimal(RandomKit.getRandom().nextDouble(minInclude.doubleValue(), maxExclude.doubleValue()));
    }

    public static <T> T randomEle(List<T> list) {
        return RandomKit.randomEle(list, list.size());
    }

    public static <T> T randomEle(List<T> list, int limit) {
        if (list.size() < limit) {
            limit = list.size();
        }
        return list.get(RandomKit.randomInt(limit));
    }

    public static <T> T randomEle(T[] array) {
        return RandomKit.randomEle(array, array.length);
    }

    public static <T> T randomEle(T[] array, int limit) {
        if (array.length < limit) {
            limit = array.length;
        }
        return array[RandomKit.randomInt(limit)];
    }

    public static <T> List<T> randomEles(List<T> list, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (result.size() < count) {
            result.add(RandomKit.randomEle(list, limit));
        }
        return result;
    }

    public static <T> List<T> randomPick(List<T> source, int count) {
        if (count >= source.size()) {
            return ListKit.of(source);
        }
        int[] randomList = ArrayKit.sub(RandomKit.randomInts(source.size()), 0, count);
        ArrayList<T> result = new ArrayList<T>();
        for (int e : randomList) {
            result.add(source.get(e));
        }
        return result;
    }

    public static int[] randomPickInts(int size, int[] seed) {
        Assert.isTrue(seed.length >= size, "Size is larger than seed size!", new Object[0]);
        int[] ranArr = new int[size];
        for (int i = 0; i < size; ++i) {
            int j = RandomKit.randomInt(seed.length - i);
            ranArr[i] = seed[j];
            seed[j] = seed[seed.length - 1 - i];
        }
        return ranArr;
    }

    public static <T> Set<T> randomEleSet(Collection<T> collection, int count) {
        List<T> source = CollKit.distinct(collection);
        if (count > source.size()) {
            throw new IllegalArgumentException("Count is larger than collection distinct size !");
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(count);
        int limit = source.size();
        while (result.size() < count) {
            result.add(RandomKit.randomEle(source, limit));
        }
        return result;
    }

    public static String randomString(int length) {
        return RandomKit.randomString(BASE_CHAR_NUMBER, length);
    }

    public static String randomStringLower(int length) {
        return RandomKit.randomString("abcdefghijklmnopqrstuvwxyz0123456789", length);
    }

    public static String randomStringUpper(int length) {
        return RandomKit.randomString("abcdefghijklmnopqrstuvwxyz0123456789", length).toUpperCase();
    }

    public static String randomStringWithoutString(int length, String elemData) {
        String baseStr = BASE_CHAR_NUMBER;
        baseStr = StringKit.removeAll((CharSequence)baseStr, elemData.toCharArray());
        return RandomKit.randomString(baseStr, length);
    }

    public static String randomStringLowerWithoutString(int length, String elemData) {
        String baseStr = "abcdefghijklmnopqrstuvwxyz0123456789";
        baseStr = StringKit.removeAll((CharSequence)baseStr, elemData.toLowerCase().toCharArray());
        return RandomKit.randomString(baseStr, length);
    }

    public static String randomNumbers(int length) {
        return RandomKit.randomString("0123456789", length);
    }

    public static String randomString(String baseString, int length) {
        if (StringKit.isEmpty(baseString)) {
            return "";
        }
        if (length < 1) {
            length = 1;
        }
        StringBuilder sb = new StringBuilder(length);
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomKit.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public static char randomNumber() {
        return RandomKit.randomChar("0123456789");
    }

    public static char randomChar() {
        return RandomKit.randomChar("abcdefghijklmnopqrstuvwxyz0123456789");
    }

    public static char randomChar(String baseString) {
        return baseString.charAt(RandomKit.randomInt(baseString.length()));
    }

    public static <T> WeightRandomSelector<T> weightRandom(WeightObject<T>[] weightObjs) {
        return new WeightRandomSelector<T>(weightObjs);
    }

    public static <T> WeightRandomSelector<T> weightRandom(Iterable<WeightObject<T>> weightObjs) {
        return new WeightRandomSelector<T>(weightObjs);
    }

    public static DateTime randomDay(int min, int max) {
        return RandomKit.randomDate(DateKit.now(), Various.DAY_OF_YEAR, min, max);
    }

    public static DateTime randomDate(Date baseDate, Various various, int min, int max) {
        if (null == baseDate) {
            baseDate = DateKit.now();
        }
        return DateKit.offset(baseDate, various, RandomKit.randomInt(min, max));
    }
}

