/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2024 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 */
package org.miaixz.bus.core.lang.selector;

/**
 * 平滑权重对象
 *
 * @param <T> 对象类型
 * @author Kimi Liu
 * @since Java 17+
 */
public class SmoothWeightObject<T> extends WeightObject<T> {

    private int currentWeight;

    /**
     * 构造
     *
     * @param obj    对象
     * @param weight 权重
     */
    public SmoothWeightObject(final T obj, final int weight) {
        this(obj, weight, 0);
    }

    /**
     * 构造
     *
     * @param obj           对象
     * @param weight        权重
     * @param currentWeight 当前权重
     */
    public SmoothWeightObject(final T obj, final int weight, final int currentWeight) {
        super(obj, weight);
        this.currentWeight = currentWeight;
    }

    /**
     * 获取当前权重
     *
     * @return int 临时权重
     */
    public int getCurrentWeight() {
        return currentWeight;
    }

    /**
     * setCurrentWeight
     * <p>设置当前权重
     *
     * @param currentWeight 权重值
     */
    public void setCurrentWeight(final int currentWeight) {
        this.currentWeight = currentWeight;
    }

}
