/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.beans.desc;

import org.miaixz.bus.core.beans.desc.BeanDesc;
import org.miaixz.bus.core.beans.desc.RecordBeanDesc;
import org.miaixz.bus.core.beans.desc.SimpleBeanDesc;
import org.miaixz.bus.core.beans.desc.StrictBeanDesc;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.lang.reflect.JdkProxy;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.RecordKit;

public class BeanDescFactory {
    private static final WeakConcurrentMap<Class<?>, BeanDesc> Cache = new WeakConcurrentMap();

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return Cache.computeIfAbsent(clazz, key -> BeanDescFactory.getBeanDescWithoutCache(clazz));
    }

    public static BeanDesc getBeanDescWithoutCache(Class<?> clazz) {
        if (RecordKit.isRecord(clazz)) {
            return new RecordBeanDesc(clazz);
        }
        if (JdkProxy.isProxyClass(clazz) || ArrayKit.isEmpty(FieldKit.getFields(clazz))) {
            return new SimpleBeanDesc(clazz);
        }
        return new StrictBeanDesc(clazz);
    }

    public static void clearCache() {
        Cache.clear();
    }
}

