/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.beans.desc;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Map;
import org.miaixz.bus.core.beans.desc.AbstractBeanDesc;
import org.miaixz.bus.core.beans.desc.PropDesc;
import org.miaixz.bus.core.xyz.BooleanKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.StringKit;

public class SimpleBeanDesc
extends AbstractBeanDesc {
    private static final long serialVersionUID = -1L;

    public SimpleBeanDesc(Class<?> beanClass) {
        super(beanClass);
        this.init();
    }

    private void init() {
        Method[] gettersAndSetters;
        Map propMap = this.propMap;
        block5: for (Method method : gettersAndSetters = MethodKit.getPublicMethods(this.beanClass, MethodKit::isGetterOrSetterIgnoreCase)) {
            int nameIndex;
            boolean isSetter;
            String methodName = method.getName();
            switch (methodName.charAt(0)) {
                case 's': {
                    isSetter = true;
                    nameIndex = 3;
                    break;
                }
                case 'g': {
                    isSetter = false;
                    nameIndex = 3;
                    break;
                }
                case 'i': {
                    isSetter = false;
                    nameIndex = 2;
                    break;
                }
                default: {
                    continue block5;
                }
            }
            String fieldName = Introspector.decapitalize(StringKit.toStringOrNull(methodName.substring(nameIndex)));
            PropDesc propDesc = (PropDesc)propMap.get(fieldName);
            if (null == propDesc) {
                propDesc = new PropDesc(fieldName, isSetter ? null : method, isSetter ? method : null);
                propMap.put(fieldName, propDesc);
                continue;
            }
            if (isSetter) {
                if (null != propDesc.setter && !propDesc.setter.getParameterTypes()[0].isAssignableFrom(method.getParameterTypes()[0])) continue;
                propDesc.setter = method;
                continue;
            }
            if (null != propDesc.getter && (!BooleanKit.isBoolean(propDesc.getter.getReturnType()) || !BooleanKit.isBoolean(method.getReturnType()) || !methodName.startsWith("is"))) continue;
            propDesc.getter = method;
        }
    }
}

