/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.provider;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.miaixz.bus.core.cache.provider.CacheObject;

public class CacheObjectIterator<K, V>
implements Iterator<CacheObject<K, V>>,
Serializable {
    private static final long serialVersionUID = -1L;
    private final Iterator<CacheObject<K, V>> iterator;
    private CacheObject<K, V> nextValue;

    CacheObjectIterator(Iterator<CacheObject<K, V>> iterator) {
        this.iterator = iterator;
        this.nextValue();
    }

    @Override
    public boolean hasNext() {
        return this.nextValue != null;
    }

    @Override
    public CacheObject<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        CacheObject<K, V> cachedObject = this.nextValue;
        this.nextValue();
        return cachedObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cache values Iterator is not support to modify.");
    }

    private void nextValue() {
        while (this.iterator.hasNext()) {
            this.nextValue = this.iterator.next();
            if (this.nextValue.isExpired()) continue;
            return;
        }
        this.nextValue = null;
    }
}

