/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.miaixz.bus.core.center.CollectionValidator;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.CollectorKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.SetKit;
import org.miaixz.bus.core.xyz.StreamKit;

public class CollectionStream
extends CollectionValidator {
    public static <V, K> Map<K, V> toIdentityMap(Collection<V> collection, Function<V, K> key) {
        return CollectionStream.toIdentityMap(collection, key, false);
    }

    public static <V, K> Map<K, V> toIdentityMap(Collection<V> collection, Function<V, K> key, boolean isParallel) {
        if (CollKit.isEmpty(collection)) {
            return MapKit.zero();
        }
        return CollectionStream.toMap(collection, v -> Optional.ofNullable(v).map(key).get(), Function.identity(), isParallel);
    }

    public static <E, K, V> Map<K, V> toMap(Collection<E> collection, Function<E, K> key, Function<E, V> value) {
        return CollectionStream.toMap(collection, key, value, false);
    }

    public static <E, K, V> Map<K, V> toMap(Collection<E> collection, Function<E, K> key, Function<E, V> value, boolean isParallel) {
        if (CollKit.isEmpty(collection)) {
            return MapKit.zero();
        }
        return StreamKit.of(collection, isParallel).collect(HashMap::new, (m, v) -> m.put(key.apply(v), value.apply(v)), HashMap::putAll);
    }

    public static <E, K> Map<K, List<E>> groupByKey(Collection<E> collection, Function<E, K> key) {
        return CollectionStream.groupByKey(collection, key, false);
    }

    public static <E, K> Map<K, List<E>> groupByKey(Collection<E> collection, Function<E, K> key, boolean isParallel) {
        if (CollKit.isEmpty(collection)) {
            return MapKit.zero();
        }
        return CollectionStream.groupBy(collection, key, Collectors.toList(), isParallel);
    }

    public static <E, K, U> Map<K, Map<U, List<E>>> groupBy2Key(Collection<E> collection, Function<E, K> key1, Function<E, U> key2) {
        return CollectionStream.groupBy2Key(collection, key1, key2, false);
    }

    public static <E, K, U> Map<K, Map<U, List<E>>> groupBy2Key(Collection<E> collection, Function<E, K> key1, Function<E, U> key2, boolean isParallel) {
        if (CollKit.isEmpty(collection)) {
            return MapKit.zero();
        }
        return CollectionStream.groupBy(collection, key1, CollectorKit.groupingBy(key2, Collectors.toList()), isParallel);
    }

    public static <E, T, U> Map<T, Map<U, E>> group2Map(Collection<E> collection, Function<E, T> key1, Function<E, U> key2) {
        return CollectionStream.group2Map(collection, key1, key2, false);
    }

    public static <E, T, U> Map<T, Map<U, E>> group2Map(Collection<E> collection, Function<E, T> key1, Function<E, U> key2, boolean isParallel) {
        if (CollKit.isEmpty(collection) || key1 == null || key2 == null) {
            return MapKit.zero();
        }
        return CollectionStream.groupBy(collection, key1, CollectorKit.toMap(key2, Function.identity(), (l, r) -> l), isParallel);
    }

    public static <E, K, V> Map<K, List<V>> groupKeyValue(Collection<E> collection, Function<E, K> key, Function<E, V> value) {
        return CollectionStream.groupKeyValue(collection, key, value, false);
    }

    public static <E, K, V> Map<K, List<V>> groupKeyValue(Collection<E> collection, Function<E, K> key, Function<E, V> value, boolean isParallel) {
        if (CollKit.isEmpty(collection)) {
            return MapKit.zero();
        }
        return CollectionStream.groupBy(collection, key, Collectors.mapping(v -> Optional.ofNullable(v).map(value).orElse(null), Collectors.toList()), isParallel);
    }

    public static <E, K, D> Map<K, D> groupBy(Collection<E> collection, Function<E, K> key, Collector<E, ?, D> downstream) {
        if (CollKit.isEmpty(collection)) {
            return MapKit.zero();
        }
        return CollectionStream.groupBy(collection, key, downstream, false);
    }

    public static <E, K, D> Map<K, D> groupBy(Collection<E> collection, Function<E, K> key, Collector<E, ?, D> downstream, boolean isParallel) {
        if (CollKit.isEmpty(collection)) {
            return MapKit.zero();
        }
        return StreamKit.of(collection, isParallel).collect(CollectorKit.groupingBy(key, downstream));
    }

    public static <E, T> List<T> toList(Collection<E> collection, Function<E, T> function) {
        return CollectionStream.toList(collection, function, false);
    }

    public static <E, T> List<T> toList(Collection<E> collection, Function<E, T> function, boolean isParallel) {
        if (CollKit.isEmpty(collection)) {
            return ListKit.zero();
        }
        return StreamKit.of(collection, isParallel).map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <E, T> Set<T> toSet(Collection<E> collection, Function<E, T> function) {
        return CollectionStream.toSet(collection, function, false);
    }

    public static <E, T> Set<T> toSet(Collection<E> collection, Function<E, T> function, boolean isParallel) {
        if (CollKit.isEmpty(collection)) {
            return SetKit.zero();
        }
        return StreamKit.of(collection, isParallel).map(function).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <K, X, Y, V> Map<K, V> merge(Map<K, X> map1, Map<K, Y> map2, BiFunction<X, Y, V> merge) {
        if (MapKit.isEmpty(map1) && MapKit.isEmpty(map2)) {
            return MapKit.zero();
        }
        if (MapKit.isEmpty(map1)) {
            map1 = MapKit.empty();
        } else if (MapKit.isEmpty(map2)) {
            map2 = MapKit.empty();
        }
        HashSet<K> key = new HashSet<K>();
        key.addAll(map1.keySet());
        key.addAll(map2.keySet());
        HashMap map = MapKit.newHashMap(key.size());
        for (Object t : key) {
            Object y;
            Object x = map1.get(t);
            V z = merge.apply(x, y = map2.get(t));
            if (z == null) continue;
            map.put(t, z);
        }
        return map;
    }
}

