/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.array;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.array.ArrayWrapper;
import org.miaixz.bus.core.center.object.ObjectValidator;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ArrayValidator {
    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(long[] array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static boolean isNotEmpty(int[] array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static boolean isNotEmpty(short[] array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static boolean isNotEmpty(char[] array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static boolean isNotEmpty(byte[] array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static boolean isNotEmpty(double[] array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static boolean isNotEmpty(float[] array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static boolean isNotEmpty(boolean[] array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static boolean hasBlank(CharSequence ... args) {
        if (ArrayValidator.isEmpty(args)) {
            return true;
        }
        for (CharSequence text : args) {
            if (!StringKit.isBlank(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return !ArrayValidator.hasBlank(args);
    }

    public static boolean isAllBlank(CharSequence ... args) {
        if (ArrayValidator.isEmpty(args)) {
            return true;
        }
        for (CharSequence text : args) {
            if (!StringKit.isNotBlank(text)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        return ArrayValidator.isEmpty(array) ? defaultArray : array;
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (ArrayValidator.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayValidator.isEmpty(array);
    }

    public static <T> boolean isSorted(T[] array, Comparator<? super T> comparator) {
        if (ArrayValidator.isEmpty(array) || null == comparator) {
            return false;
        }
        int size = array.length - 1;
        int cmp = comparator.compare(array[0], array[size]);
        if (cmp < 0) {
            return ArrayValidator.isSortedASC(array, comparator);
        }
        if (cmp > 0) {
            return ArrayValidator.isSortedDESC(array, comparator);
        }
        for (int i = 0; i < size; ++i) {
            if (comparator.compare(array[i], array[i + 1]) == 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        int size = array.length - 1;
        int cmp = array[0].compareTo(array[size]);
        if (cmp < 0) {
            return ArrayValidator.isSortedASC(array);
        }
        if (cmp > 0) {
            return ArrayValidator.isSortedDESC(array);
        }
        for (int i = 0; i < size; ++i) {
            if (array[i].compareTo(array[i + 1]) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedASC(byte[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(byte[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedASC(short[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(short[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedASC(char[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(char[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedASC(int[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(int[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedASC(long[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(long[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedASC(double[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] > array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(double[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] < array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedASC(float[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] > array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(float[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] < array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSortedASC(T[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        int size = array.length - 1;
        for (int i = 0; i < size; ++i) {
            if (array[i].compareTo(array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSortedDESC(T[] array) {
        if (ArrayValidator.isEmpty(array)) {
            return false;
        }
        int size = array.length - 1;
        for (int i = 0; i < size; ++i) {
            if (array[i].compareTo(array[i + 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isSortedASC(T[] array, Comparator<? super T> comparator) {
        if (ArrayValidator.isEmpty(array) || null == comparator) {
            return false;
        }
        int size = array.length - 1;
        for (int i = 0; i < size; ++i) {
            if (comparator.compare(array[i], array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isSortedDESC(T[] array, Comparator<? super T> comparator) {
        if (ArrayValidator.isEmpty(array) || null == comparator) {
            return false;
        }
        int size = array.length - 1;
        for (int i = 0; i < size; ++i) {
            if (comparator.compare(array[i], array[i + 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isAllEmpty(T[] args) {
        for (T obj : args) {
            if (ObjectKit.isEmpty(obj)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubEquals(byte[] array, int offset, byte ... subArray) {
        if (array == subArray) {
            return true;
        }
        if (array.length < subArray.length) {
            return false;
        }
        return ArrayValidator.regionMatches(array, offset, subArray, 0, subArray.length);
    }

    public static <T> boolean isSub(T[] array, T[] subArray) {
        return ArrayValidator.indexOfSub(array, subArray) > -1;
    }

    public static <T> int indexOfSub(T[] array, int beginInclude, T[] subArray) {
        if (ArrayValidator.isEmpty(array) || ArrayValidator.isEmpty(subArray) || subArray.length > array.length) {
            return -1;
        }
        int firstIndex = ArrayValidator.indexOf(array, subArray[0], beginInclude);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjectKit.equals(array[i + firstIndex], subArray[i])) continue;
            return ArrayValidator.indexOfSub(array, firstIndex + 1, subArray);
        }
        return firstIndex;
    }

    @SafeVarargs
    public static <T> boolean isAllEmptyVarargs(T ... args) {
        return ArrayValidator.isAllEmpty(args);
    }

    public static boolean isAllNotEmpty(Object ... args) {
        return !ArrayValidator.hasEmpty(args);
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayValidator.isNotEmpty(array)) {
            for (T element : array) {
                if (!ObjectKit.isNull(element)) continue;
                return true;
            }
        }
        return array == null;
    }

    public static <T> boolean hasEmpty(T[] args) {
        if (ArrayValidator.isNotEmpty(args)) {
            for (T element : args) {
                if (!ObjectKit.isEmpty(element)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean hasEmptyVarargs(T ... args) {
        return ArrayValidator.hasEmpty(args);
    }

    public static <T> boolean isAllNull(T ... array) {
        return null == ArrayValidator.firstNonNull(array);
    }

    public static <T> boolean isAllNotNull(T ... array) {
        return !ArrayValidator.hasNull(array);
    }

    public static <T> boolean hasNonNull(T ... array) {
        return null != ArrayValidator.firstNonNull(array);
    }

    public static int emptyCount(Object ... args) {
        int count = 0;
        if (ArrayValidator.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjectKit.isEmpty(element)) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T> T firstNonNull(T ... array) {
        if (ArrayValidator.isEmpty(array)) {
            return null;
        }
        return (T)ArrayValidator.firstMatch(ObjectValidator::isNotNull, array);
    }

    public static <T> T firstMatch(Predicate<T> matcher, T ... array) {
        int index = ArrayValidator.matchIndex(matcher, array);
        if (index == -1) {
            return null;
        }
        return array[index];
    }

    public static <T> int matchIndex(Predicate<T> matcher, T ... array) {
        return ArrayValidator.matchIndex(0, matcher, array);
    }

    public static <E> int matchIndex(int beginIndexInclude, Predicate<E> matcher, E ... array) {
        if (ArrayValidator.isEmpty(array)) {
            return -1;
        }
        ArrayWrapper<E[], E> arrayWrapper = ArrayWrapper.of(array);
        return arrayWrapper.matchIndex(beginIndexInclude, matcher);
    }

    public static <T> int indexOf(T[] array, Object value, int beginIndexInclude) {
        return ArrayWrapper.of(array).indexOf(value, beginIndexInclude);
    }

    public static <T> int indexOf(T[] array, Object value) {
        return ArrayWrapper.of(array).indexOf(value);
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        if (ArrayValidator.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (!StringKit.equalsIgnoreCase(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, Object value) {
        if (ArrayValidator.isEmpty(array)) {
            return -1;
        }
        return ArrayValidator.lastIndexOf(array, value, array.length - 1);
    }

    public static <T> int lastIndexOf(T[] array, Object value, int endInclude) {
        if (ArrayValidator.isNotEmpty(array)) {
            for (int i = endInclude; i >= 0; --i) {
                if (!ObjectKit.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int indexOfSub(T[] array, T[] subArray) {
        return ArrayValidator.indexOfSub(array, 0, subArray);
    }

    public static boolean regionMatches(byte[] array1, int offset1, byte[] array2, int offset2, int length) {
        if (array1.length < offset1 + length) {
            throw new IndexOutOfBoundsException("[byte1] length must be >= [offset1 + length]");
        }
        if (array2.length < offset2 + length) {
            throw new IndexOutOfBoundsException("[byte2] length must be >= [offset2 + length]");
        }
        for (int i = 0; i < length; ++i) {
            if (array1[i + offset1] == array2[i + offset2]) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayKit.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }
}

