/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import org.miaixz.bus.core.center.date.Resolver;
import org.miaixz.bus.core.center.date.culture.en.Week;

public class Calculate
extends Resolver {
    public static boolean isIn(TemporalAccessor date, TemporalAccessor beginDate, TemporalAccessor endDate) {
        return Calculate.isIn(date, beginDate, endDate, true, true);
    }

    public static boolean isIn(TemporalAccessor date, TemporalAccessor beginDate, TemporalAccessor endDate, boolean includeBegin, boolean includeEnd) {
        boolean isIn;
        if (date == null || beginDate == null || endDate == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u53ef\u4e3anull");
        }
        long thisMills = Calculate.toEpochMilli(date);
        long beginMills = Calculate.toEpochMilli(beginDate);
        long endMills = Calculate.toEpochMilli(endDate);
        long rangeMin = Math.min(beginMills, endMills);
        long rangeMax = Math.max(beginMills, endMills);
        boolean bl = isIn = rangeMin < thisMills && thisMills < rangeMax;
        if (!isIn && includeBegin) {
            boolean bl2 = isIn = thisMills == rangeMin;
        }
        if (!isIn && includeEnd) {
            isIn = thisMills == rangeMax;
        }
        return isIn;
    }

    public static boolean isOverlap(ChronoLocalDateTime<?> realStartTime, ChronoLocalDateTime<?> realEndTime, ChronoLocalDateTime<?> startTime, ChronoLocalDateTime<?> endTime) {
        return realStartTime.compareTo(endTime) <= 0 && startTime.compareTo(realEndTime) <= 0;
    }

    public static boolean isSameDay(ChronoLocalDateTime<?> date1, ChronoLocalDateTime<?> date2) {
        return date1 != null && date2 != null && date1.toLocalDate().isEqual((ChronoLocalDate)date2.toLocalDate());
    }

    public static boolean isSameDay(ChronoLocalDate date1, ChronoLocalDate date2) {
        return date1 != null && date2 != null && date1.isEqual(date2);
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return Calculate.isWeekend(localDateTime.toLocalDate());
    }

    public static boolean isWeekend(LocalDate localDate) {
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        return DayOfWeek.SATURDAY == dayOfWeek || DayOfWeek.SUNDAY == dayOfWeek;
    }

    public static boolean isLeapYear(int year) {
        return Year.isLeap(year);
    }

    public static LocalDateTime offset(LocalDateTime time, long number, TemporalUnit field) {
        return Calculate.offset(time, number, field);
    }

    public static <T extends Temporal> T offset(T time, long number, TemporalUnit field) {
        if (null == time) {
            return null;
        }
        return (T)time.plus(number, field);
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        return time.with(LocalTime.MIN);
    }

    public static LocalDateTime beginOfDay(LocalDate date) {
        return date.atStartOfDay();
    }

    public static LocalDateTime endOfDay(LocalDateTime time, boolean truncateMillisecond) {
        return time.with(Calculate.max(truncateMillisecond));
    }

    public static LocalDateTime endOfDay(LocalDate date, boolean truncateMillisecond) {
        return LocalDateTime.of(date, Calculate.max(truncateMillisecond));
    }

    public static LocalDateTime beginOfMonth(LocalDateTime time) {
        return Calculate.beginOfDay(Calculate.beginOfMonth(time.toLocalDate()));
    }

    public static LocalDate beginOfMonth(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDateTime endOfMonth(LocalDateTime time, boolean truncateMillisecond) {
        return Calculate.endOfDay(Calculate.endOfMonth(time.toLocalDate()), truncateMillisecond);
    }

    public static LocalDate endOfMonth(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDateTime beginOfYear(LocalDateTime time) {
        return Calculate.beginOfDay(Calculate.beginOfYear(time.toLocalDate()));
    }

    public static LocalDate beginOfYear(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfYear());
    }

    public static LocalDateTime endOfYear(LocalDateTime time, boolean truncateMillisecond) {
        return Calculate.endOfDay(Calculate.endOfYear(time.toLocalDate()), truncateMillisecond);
    }

    public static LocalDate endOfYear(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfYear());
    }

    public static Week dayOfWeek(LocalDate localDate) {
        return Week.of(localDate.getDayOfWeek());
    }

    public static int weekOfYear(TemporalAccessor date) {
        return Calculate.get(date, WeekFields.ISO.weekOfYear());
    }

    public static LocalTime max(boolean truncateMillisecond) {
        return truncateMillisecond ? MAX_HMS : LocalTime.MAX;
    }

    public <T extends Temporal> T offset(T temporal, DayOfWeek dayOfWeek, boolean isPrevious) {
        return (T)temporal.with(isPrevious ? TemporalAdjusters.previous(dayOfWeek) : TemporalAdjusters.next(dayOfWeek));
    }
}

