/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date;

import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.miaixz.bus.core.center.date.Calculate;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.center.date.Modifier;
import org.miaixz.bus.core.center.date.culture.en.Modify;
import org.miaixz.bus.core.center.date.culture.en.Month;
import org.miaixz.bus.core.center.date.culture.en.Various;
import org.miaixz.bus.core.center.date.format.CustomFormat;
import org.miaixz.bus.core.center.date.format.parser.FastDateParser;
import org.miaixz.bus.core.center.date.format.parser.PositionDateParser;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.DateException;
import org.miaixz.bus.core.math.ChineseNumberFormatter;
import org.miaixz.bus.core.xyz.CompareKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Calendar
extends Calculate {
    public static boolean isAM(java.util.Calendar calendar) {
        return 0 == calendar.get(9);
    }

    public static boolean isPM(java.util.Calendar calendar) {
        return 1 == calendar.get(9);
    }

    public static boolean isSameDay(java.util.Calendar cal1, java.util.Calendar cal2) {
        if (ObjectKit.notEquals(cal1.getTimeZone(), cal2.getTimeZone())) {
            cal2 = Calendar.calendar(cal2, cal1.getTimeZone());
        }
        return Calendar.isSameYear(cal1, cal2) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameWeek(java.util.Calendar cal1, java.util.Calendar cal2, boolean isMon) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        cal2 = ObjectKit.notEquals((cal1 = (java.util.Calendar)cal1.clone()).getTimeZone(), cal2.getTimeZone()) ? Calendar.calendar(cal2, cal1.getTimeZone()) : (java.util.Calendar)cal2.clone();
        if (isMon) {
            cal1.setFirstDayOfWeek(2);
            cal1.set(7, 2);
            cal2.setFirstDayOfWeek(2);
            cal2.set(7, 2);
        } else {
            cal1.setFirstDayOfWeek(1);
            cal1.set(7, 1);
            cal2.setFirstDayOfWeek(1);
            cal2.set(7, 1);
        }
        return Calendar.isSameDay(cal1, cal2);
    }

    public static boolean isSameMonth(java.util.Calendar cal1, java.util.Calendar cal2) {
        if (ObjectKit.notEquals(cal1.getTimeZone(), cal2.getTimeZone())) {
            cal2 = Calendar.calendar(cal2, cal1.getTimeZone());
        }
        return Calendar.isSameYear(cal1, cal2) && cal1.get(2) == cal2.get(2);
    }

    public static boolean isSameYear(java.util.Calendar cal1, java.util.Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (ObjectKit.notEquals(cal1.getTimeZone(), cal2.getTimeZone())) {
            cal2 = Calendar.calendar(cal2, cal1.getTimeZone());
        }
        return cal1.get(1) == cal2.get(1) && cal1.get(0) == cal2.get(0);
    }

    public static boolean isSameInstant(java.util.Calendar date1, java.util.Calendar date2) {
        if (null == date1) {
            return null == date2;
        }
        if (null == date2) {
            return false;
        }
        return date1.getTimeInMillis() == date2.getTimeInMillis();
    }

    public static boolean isFirstDayOfMonth(java.util.Calendar calendar) {
        return 1 == calendar.get(5);
    }

    public static boolean isLastDayOfMonth(java.util.Calendar calendar) {
        return calendar.get(5) == calendar.getActualMaximum(5);
    }

    public static java.util.Calendar calendar() {
        return java.util.Calendar.getInstance();
    }

    public static java.util.Calendar calendar(Date date) {
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        return Calendar.calendar(date.getTime());
    }

    public static java.util.Calendar calendar(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar();
    }

    public static java.util.Calendar calendar(long millis) {
        return Calendar.calendar(millis, TimeZone.getDefault());
    }

    public static java.util.Calendar calendar(long millis, TimeZone timeZone) {
        java.util.Calendar cal = java.util.Calendar.getInstance(timeZone);
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static java.util.Calendar calendar(java.util.Calendar calendar, TimeZone timeZone) {
        calendar = (java.util.Calendar)calendar.clone();
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    public static java.util.Calendar truncate(java.util.Calendar calendar, Various various) {
        return Modifier.modify(calendar, various.getValue(), Modify.TRUNCATE);
    }

    public static java.util.Calendar round(java.util.Calendar calendar, Various various) {
        return Modifier.modify(calendar, various.getValue(), Modify.ROUND);
    }

    public static java.util.Calendar ceiling(java.util.Calendar calendar, Various various) {
        return Modifier.modify(calendar, various.getValue(), Modify.CEILING);
    }

    public static java.util.Calendar ceiling(java.util.Calendar calendar, Various various, boolean truncateMillisecond) {
        return Modifier.modify(calendar, various.getValue(), Modify.CEILING, truncateMillisecond);
    }

    public static java.util.Calendar beginOfSecond(java.util.Calendar calendar) {
        return Calendar.truncate(calendar, Various.SECOND);
    }

    public static java.util.Calendar endOfSecond(java.util.Calendar calendar) {
        return Calendar.ceiling(calendar, Various.SECOND);
    }

    public static java.util.Calendar beginOfHour(java.util.Calendar calendar) {
        return Calendar.truncate(calendar, Various.HOUR_OF_DAY);
    }

    public static java.util.Calendar endOfHour(java.util.Calendar calendar) {
        return Calendar.ceiling(calendar, Various.HOUR_OF_DAY);
    }

    public static java.util.Calendar beginOfMinute(java.util.Calendar calendar) {
        return Calendar.truncate(calendar, Various.MINUTE);
    }

    public static java.util.Calendar endOfMinute(java.util.Calendar calendar) {
        return Calendar.ceiling(calendar, Various.MINUTE);
    }

    public static java.util.Calendar beginOfDay(java.util.Calendar calendar) {
        return Calendar.truncate(calendar, Various.DAY_OF_MONTH);
    }

    public static java.util.Calendar endOfDay(java.util.Calendar calendar) {
        return Calendar.ceiling(calendar, Various.DAY_OF_MONTH);
    }

    public static java.util.Calendar beginOfWeek(java.util.Calendar calendar) {
        return Calendar.beginOfWeek(calendar, true);
    }

    public static java.util.Calendar beginOfWeek(java.util.Calendar calendar, boolean isMondayAsFirstDay) {
        calendar.setFirstDayOfWeek(isMondayAsFirstDay ? 2 : 1);
        return Calendar.truncate(calendar, Various.WEEK_OF_MONTH);
    }

    public static java.util.Calendar endOfWeek(java.util.Calendar calendar) {
        return Calendar.endOfWeek(calendar, true);
    }

    public static java.util.Calendar endOfWeek(java.util.Calendar calendar, boolean isSundayAsLastDay) {
        calendar.setFirstDayOfWeek(isSundayAsLastDay ? 2 : 1);
        return Calendar.ceiling(calendar, Various.WEEK_OF_MONTH);
    }

    public static java.util.Calendar beginOfMonth(java.util.Calendar calendar) {
        return Calendar.truncate(calendar, Various.MONTH);
    }

    public static java.util.Calendar endOfMonth(java.util.Calendar calendar) {
        return Calendar.ceiling(calendar, Various.MONTH);
    }

    public static java.util.Calendar beginOfQuarter(java.util.Calendar calendar) {
        calendar.set(2, calendar.get(Various.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return Calendar.beginOfDay(calendar);
    }

    public static java.util.Calendar endOfQuarter(java.util.Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(Various.MONTH.getValue()) / 3 * 3 + 2;
        java.util.Calendar resultCal = java.util.Calendar.getInstance(calendar.getTimeZone());
        resultCal.set(year, month, Month.of(month).getLastDay(Calculate.isLeapYear(year)));
        return Calendar.endOfDay(resultCal);
    }

    public static java.util.Calendar beginOfYear(java.util.Calendar calendar) {
        return Calendar.truncate(calendar, Various.YEAR);
    }

    public static java.util.Calendar endOfYear(java.util.Calendar calendar) {
        return Calendar.ceiling(calendar, Various.YEAR);
    }

    public static String yearAndQuarter(java.util.Calendar cal) {
        return StringKit.builder().append(cal.get(1)).append(cal.get(2) / 3 + 1).toString();
    }

    public static int getBeginValue(java.util.Calendar calendar, Various various) {
        return Calendar.getBeginValue(calendar, various.getValue());
    }

    public static int getBeginValue(java.util.Calendar calendar, int dateField) {
        if (7 == dateField) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar.getActualMinimum(dateField);
    }

    public static int getEndValue(java.util.Calendar calendar, Various various) {
        return Calendar.getEndValue(calendar, various.getValue());
    }

    public static int getEndValue(java.util.Calendar calendar, int dateField) {
        if (7 == dateField) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar.getActualMaximum(dateField);
    }

    public static int getField(java.util.Calendar calendar, Various field) {
        return Assert.notNull(calendar).get(Assert.notNull(field).getValue());
    }

    public static Instant toInstant(java.util.Calendar calendar) {
        return null == calendar ? null : calendar.toInstant();
    }

    public static LocalDateTime toLocalDateTime(java.util.Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
    }

    public static int compare(java.util.Calendar calendar1, java.util.Calendar calendar2) {
        return CompareKit.compare(calendar1, calendar2);
    }

    public static String formatChineseDate(java.util.Calendar calendar, boolean withTime) {
        StringBuilder result = StringKit.builder();
        String year = String.valueOf(calendar.get(1));
        int length = year.length();
        for (int i = 0; i < length; ++i) {
            result.append(ChineseNumberFormatter.formatChar(year.charAt(i), false));
        }
        result.append('\u5e74');
        int month = calendar.get(2) + 1;
        result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(month));
        result.append('\u6708');
        int day = calendar.get(5);
        result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(day));
        result.append('\u65e5');
        String temp = result.toString().replace('\u96f6', '\u3007');
        result.delete(0, result.length());
        result.append(temp);
        if (withTime) {
            int hour = calendar.get(11);
            result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(hour));
            result.append('\u65f6');
            int minute = calendar.get(12);
            result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(minute));
            result.append('\u5206');
            int second = calendar.get(13);
            result.append(ChineseNumberFormatter.of().setColloquialMode(true).format(second));
            result.append('\u79d2');
        }
        return result.toString();
    }

    public static java.util.Calendar parseByPatterns(CharSequence text, String ... parsePatterns) throws DateException {
        return Calendar.parseByPatterns(text, null, parsePatterns);
    }

    public static java.util.Calendar parseByPatterns(CharSequence text, Locale locale, String ... parsePatterns) throws DateException {
        return Calendar.parseByPatterns(text, locale, true, parsePatterns);
    }

    public static java.util.Calendar parseByPatterns(CharSequence text, Locale locale, boolean lenient, String ... parsePatterns) throws DateException {
        if (text == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = ObjectKit.defaultIfNull(locale, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        java.util.Calendar calendar = java.util.Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : parsePatterns) {
            if (CustomFormat.isCustomFormat(parsePattern)) {
                Date parse = CustomFormat.parse(text, parsePattern);
                if (null == parse) continue;
                calendar.setTime(parse);
                return calendar;
            }
            FastDateParser fdp = new FastDateParser(parsePattern, tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(text, pos, calendar) && pos.getIndex() == text.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new DateException("Unable to parse the date: {}", text);
    }

    public static java.util.Calendar parse(CharSequence text, boolean lenient, PositionDateParser parser) {
        Assert.notBlank(text, "Date text must be not blank!", new Object[0]);
        Assert.notNull(parser, "Parser must be not null!", new Object[0]);
        java.util.Calendar calendar = java.util.Calendar.getInstance(parser.getTimeZone(), parser.getLocale());
        calendar.clear();
        calendar.setLenient(lenient);
        return parser.parse(text.toString(), new ParsePosition(0), calendar) ? calendar : null;
    }

    public static int age(LocalDate birthDay) {
        Period period = Period.between(birthDay, LocalDate.now());
        if (period.getYears() < 0) {
            throw new DateTimeException("birthDay is after now!");
        }
        return period.getYears();
    }

    public static int age(LocalDateTime birthDay) {
        return Calendar.age(birthDay.toLocalDate());
    }

    public static int age(java.util.Calendar birthday, java.util.Calendar dateToCompare) {
        return Calendar.age(birthday.getTimeInMillis(), dateToCompare.getTimeInMillis());
    }

    protected static int age(long birthday, long dateToCompare) {
        if (birthday > dateToCompare) {
            throw new IllegalArgumentException("Birthday is after dateToCompare!");
        }
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTimeInMillis(dateToCompare);
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        cal.setTimeInMillis(birthday);
        int age = year - cal.get(1);
        if (age == 0) {
            return 0;
        }
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            int dayOfMonthBirth = cal.get(5);
            if (dayOfMonth <= dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }
}

