/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.cn.birth;

import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.birth.ChildLimit;
import org.miaixz.bus.core.center.date.culture.cn.birth.Fortune;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycle;
import org.miaixz.bus.core.center.date.culture.lunar.LunarYear;

public class DecadeFortune
extends Loops {
    protected ChildLimit childLimit;
    protected int index;

    public DecadeFortune(ChildLimit childLimit, int index) {
        this.childLimit = childLimit;
        this.index = index;
    }

    public static DecadeFortune fromChildLimit(ChildLimit childLimit, int index) {
        return new DecadeFortune(childLimit, index);
    }

    public int getStartAge() {
        return this.childLimit.getYearCount() + 1 + this.index * 10;
    }

    public int getEndAge() {
        return this.getStartAge() + 9;
    }

    public LunarYear getStartLunarYear() {
        return this.childLimit.getEndTime().getLunarHour().getLunarDay().getLunarMonth().getLunarYear().next(this.index * 10);
    }

    public LunarYear getEndLunarYear() {
        return this.getStartLunarYear().next(9);
    }

    public SixtyCycle getSixtyCycle() {
        int n = this.index + 1;
        return this.childLimit.getEightChar().getMonth().next(this.childLimit.isForward() ? n : -n);
    }

    @Override
    public String getName() {
        return this.getSixtyCycle().getName();
    }

    @Override
    public DecadeFortune next(int n) {
        return DecadeFortune.fromChildLimit(this.childLimit, this.index + n);
    }

    public Fortune getStartFortune() {
        return Fortune.fromChildLimit(this.childLimit, this.index * 10);
    }
}

