/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.cn.birth.provider.impl;

import org.miaixz.bus.core.center.date.culture.cn.birth.ChildLimitInfo;
import org.miaixz.bus.core.center.date.culture.cn.birth.provider.ChildLimitProvider;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;
import org.miaixz.bus.core.center.date.culture.solar.SolarTime;

public class DefaultChildLimitProvider
implements ChildLimitProvider {
    @Override
    public ChildLimitInfo getInfo(SolarTime birthTime, SolarTerms term) {
        int seconds = Math.abs(term.getJulianDay().getSolarTime().subtract(birthTime));
        int year = seconds / 259200;
        int month = (seconds %= 259200) / 21600;
        int day = (seconds %= 21600) / 720;
        int hour = (seconds %= 720) / 30;
        int minute = (seconds %= 30) * 2;
        SolarDay birthday = birthTime.getSolarDay();
        int d = birthday.getDay() + day;
        int h = birthTime.getHour() + hour;
        int mi = birthTime.getMinute() + minute;
        h += mi / 60;
        mi %= 60;
        d += h / 24;
        h %= 24;
        SolarMonth sm = SolarMonth.fromYm(birthday.getYear() + year, birthday.getMonth()).next(month);
        int dc = sm.getDayCount();
        if (d > dc) {
            d -= dc;
            sm = sm.next(1);
        }
        return new ChildLimitInfo(birthTime, SolarTime.fromYmdHms(sm.getYear(), sm.getMonth(), d, h, mi, birthTime.getSecond()), year, month, day, hour, minute);
    }
}

