/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.lunar;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.Direction;
import org.miaixz.bus.core.center.date.culture.cn.Duty;
import org.miaixz.bus.core.center.date.culture.cn.God;
import org.miaixz.bus.core.center.date.culture.cn.Phase;
import org.miaixz.bus.core.center.date.culture.cn.Taboo;
import org.miaixz.bus.core.center.date.culture.cn.Week;
import org.miaixz.bus.core.center.date.culture.cn.fetus.FetusDay;
import org.miaixz.bus.core.center.date.culture.cn.sixty.EarthBranch;
import org.miaixz.bus.core.center.date.culture.cn.sixty.HeavenStem;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycle;
import org.miaixz.bus.core.center.date.culture.cn.star.nine.NineStar;
import org.miaixz.bus.core.center.date.culture.cn.star.six.SixStar;
import org.miaixz.bus.core.center.date.culture.cn.star.twelve.TwelveStar;
import org.miaixz.bus.core.center.date.culture.cn.star.twentyeight.TwentyEightStar;
import org.miaixz.bus.core.center.date.culture.lunar.LunarFestival;
import org.miaixz.bus.core.center.date.culture.lunar.LunarHour;
import org.miaixz.bus.core.center.date.culture.lunar.LunarMonth;
import org.miaixz.bus.core.center.date.culture.lunar.LunarYear;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;

public class LunarDay
extends Loops {
    public static final String[] NAMES = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    protected LunarMonth month;
    protected int day;

    public LunarDay(int year, int month, int day) {
        LunarMonth m = LunarMonth.fromYm(year, month);
        if (day < 1 || day > m.getDayCount()) {
            throw new IllegalArgumentException(String.format("illegal day %d in %s", day, m));
        }
        this.month = m;
        this.day = day;
    }

    public static LunarDay fromYmd(int year, int month, int day) {
        return new LunarDay(year, month, day);
    }

    public LunarMonth getLunarMonth() {
        return this.month;
    }

    public int getYear() {
        return this.month.getYear();
    }

    public int getMonth() {
        return this.month.getMonthWithLeap();
    }

    public int getDay() {
        return this.day;
    }

    @Override
    public String getName() {
        return NAMES[this.day - 1];
    }

    @Override
    public String toString() {
        return String.valueOf(this.month) + this.getName();
    }

    @Override
    public LunarDay next(int n) {
        int add;
        if (n == 0) {
            return LunarDay.fromYmd(this.getYear(), this.getMonth(), this.day);
        }
        int d = this.day + n;
        LunarMonth m = this.month;
        int daysInMonth = m.getDayCount();
        boolean forward = n > 0;
        int n2 = add = forward ? 1 : -1;
        while (forward ? d > daysInMonth : d <= 0) {
            if (forward) {
                d -= daysInMonth;
            }
            m = m.next(add);
            daysInMonth = m.getDayCount();
            if (forward) continue;
            d += daysInMonth;
        }
        return LunarDay.fromYmd(m.getYear(), m.getMonthWithLeap(), d);
    }

    public boolean isBefore(LunarDay target) {
        int bMonth;
        int bYear;
        int aYear = this.getYear();
        if (aYear != (bYear = target.getYear())) {
            return aYear < bYear;
        }
        int aMonth = this.getMonth();
        if (aMonth != (bMonth = target.getMonth())) {
            return Math.abs(aMonth) < Math.abs(bMonth);
        }
        return this.day < target.getDay();
    }

    public boolean isAfter(LunarDay target) {
        int bMonth;
        int bYear;
        int aYear = this.getYear();
        if (aYear != (bYear = target.getYear())) {
            return aYear > bYear;
        }
        int aMonth = this.getMonth();
        if (aMonth != (bMonth = target.getMonth())) {
            return Math.abs(aMonth) >= Math.abs(bMonth);
        }
        return this.day > target.getDay();
    }

    public Week getWeek() {
        return this.getSolarDay().getWeek();
    }

    public SixtyCycle getYearSixtyCycle() {
        SolarDay solarDay = this.getSolarDay();
        int solarYear = solarDay.getYear();
        SolarDay springSolarDay = SolarTerms.fromIndex(solarYear, 3).getJulianDay().getSolarDay();
        LunarYear lunarYear = this.month.getLunarYear();
        int year = lunarYear.getYear();
        SixtyCycle sixtyCycle = lunarYear.getSixtyCycle();
        if (year == solarYear) {
            if (solarDay.isBefore(springSolarDay)) {
                sixtyCycle = sixtyCycle.next(-1);
            }
        } else if (year < solarYear && !solarDay.isBefore(springSolarDay)) {
            sixtyCycle = sixtyCycle.next(1);
        }
        return sixtyCycle;
    }

    public SixtyCycle getMonthSixtyCycle() {
        SolarDay solarDay = this.getSolarDay();
        int year = solarDay.getYear();
        SolarTerms term = solarDay.getTerm();
        int index = term.getIndex() - 3;
        if (index < 0 && term.getJulianDay().getSolarDay().isAfter(SolarTerms.fromIndex(year, 3).getJulianDay().getSolarDay())) {
            index += 24;
        }
        return LunarMonth.fromYm(year, 1).getSixtyCycle().next((int)Math.floor((double)index * 1.0 / 2.0));
    }

    public SixtyCycle getSixtyCycle() {
        int offset = (int)this.month.getFirstJulianDay().next(this.day - 12).getDay();
        return SixtyCycle.fromName(HeavenStem.fromIndex(offset).getName() + EarthBranch.fromIndex(offset).getName());
    }

    public Duty getDuty() {
        return Duty.fromIndex(this.getSixtyCycle().getEarthBranch().getIndex() - this.getMonthSixtyCycle().getEarthBranch().getIndex());
    }

    public TwelveStar getTwelveStar() {
        return TwelveStar.fromIndex(this.getSixtyCycle().getEarthBranch().getIndex() + (8 - this.getMonthSixtyCycle().getEarthBranch().getIndex() % 6) * 2);
    }

    public NineStar getNineStar() {
        SolarDay solar = this.getSolarDay();
        SolarTerms dongZhi = SolarTerms.fromIndex(solar.getYear(), 0);
        SolarTerms xiaZhi = dongZhi.next(12);
        SolarTerms dongZhi2 = dongZhi.next(24);
        SolarDay dongZhiSolar = dongZhi.getJulianDay().getSolarDay();
        SolarDay xiaZhiSolar = xiaZhi.getJulianDay().getSolarDay();
        SolarDay dongZhiSolar2 = dongZhi2.getJulianDay().getSolarDay();
        int dongZhiIndex = dongZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int xiaZhiIndex = xiaZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int dongZhiIndex2 = dongZhiSolar2.getLunarDay().getSixtyCycle().getIndex();
        SolarDay solarShunBai = dongZhiSolar.next(dongZhiIndex > 29 ? 60 - dongZhiIndex : -dongZhiIndex);
        SolarDay solarShunBai2 = dongZhiSolar2.next(dongZhiIndex2 > 29 ? 60 - dongZhiIndex2 : -dongZhiIndex2);
        SolarDay solarNiZi = xiaZhiSolar.next(xiaZhiIndex > 29 ? 60 - xiaZhiIndex : -xiaZhiIndex);
        int offset = 0;
        if (!solar.isBefore(solarShunBai) && solar.isBefore(solarNiZi)) {
            offset = solar.subtract(solarShunBai);
        } else if (!solar.isBefore(solarNiZi) && solar.isBefore(solarShunBai2)) {
            offset = 8 - solar.subtract(solarNiZi);
        } else if (!solar.isBefore(solarShunBai2)) {
            offset = solar.subtract(solarShunBai2);
        } else if (solar.isBefore(solarShunBai)) {
            offset = 8 + solarShunBai.subtract(solar);
        }
        return NineStar.fromIndex(offset);
    }

    public Direction getJupiterDirection() {
        int index = this.getSixtyCycle().getIndex();
        return index % 12 < 6 ? Direction.fromIndex((new int[]{2, 8, 4, 6, 0})[index / 12]) : this.month.getLunarYear().getJupiterDirection();
    }

    public FetusDay getFetusDay() {
        return FetusDay.fromLunarDay(this);
    }

    public Phase getPhase() {
        return Phase.fromIndex(this.day - 1);
    }

    public SixStar getSixStar() {
        return SixStar.fromIndex((this.month.getMonth() + this.day - 2) % 6);
    }

    public SolarDay getSolarDay() {
        return this.month.getFirstJulianDay().next(this.day - 1).getSolarDay();
    }

    public TwentyEightStar getTwentyEightStar() {
        return TwentyEightStar.fromIndex((new int[]{10, 18, 26, 6, 14, 22, 2})[this.getSolarDay().getWeek().getIndex()]).next(-7 * this.getSixtyCycle().getEarthBranch().getIndex());
    }

    public LunarFestival getFestival() {
        return LunarFestival.fromYmd(this.getYear(), this.getMonth(), this.day);
    }

    public List<LunarHour> getHours() {
        ArrayList<LunarHour> l = new ArrayList<LunarHour>();
        int y = this.getYear();
        int m = this.getMonth();
        l.add(LunarHour.fromYmdHms(y, m, this.day, 0, 0, 0));
        for (int i = 0; i < 24; i += 2) {
            l.add(LunarHour.fromYmdHms(y, m, this.day, i + 1, 0, 0));
        }
        return l;
    }

    public List<God> getGods() {
        return God.getDayGods(this.getMonthSixtyCycle(), this.getSixtyCycle());
    }

    public List<Taboo> getRecommends() {
        return Taboo.getDayRecommends(this.getMonthSixtyCycle(), this.getSixtyCycle());
    }

    public List<Taboo> getAvoids() {
        return Taboo.getDayAvoids(this.getMonthSixtyCycle(), this.getSixtyCycle());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LunarDay)) {
            return false;
        }
        LunarDay target = (LunarDay)o;
        return this.getMonth() == target.getMonth() && this.day == target.getDay();
    }
}

