/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.solar;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.Week;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarMonth;

public class SolarWeek
extends Loops {
    protected SolarMonth month;
    protected int index;
    protected Week start;

    public SolarWeek(int year, int month, int index, int start) {
        if (index < 0 || index > 5) {
            throw new IllegalArgumentException(String.format("illegal solar week index: %d", index));
        }
        if (start < 0 || start > 6) {
            throw new IllegalArgumentException(String.format("illegal solar week start: %d", start));
        }
        SolarMonth m = SolarMonth.fromYm(year, month);
        if (index >= m.getWeekCount(start)) {
            throw new IllegalArgumentException(String.format("illegal solar week index: %d in month: %s", index, m));
        }
        this.month = m;
        this.index = index;
        this.start = Week.fromIndex(start);
    }

    public static SolarWeek fromYm(int year, int month, int index, int start) {
        return new SolarWeek(year, month, index, start);
    }

    public SolarMonth getSolarMonth() {
        return this.month;
    }

    public int getYear() {
        return this.month.getYear();
    }

    public int getMonth() {
        return this.month.getMonth();
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndexInYear() {
        int i = 0;
        SolarWeek w = SolarWeek.fromYm(this.getYear(), 1, 0, this.start.getIndex());
        while (!w.equals(this)) {
            w = w.next(1);
            ++i;
        }
        return i;
    }

    public Week getStart() {
        return this.start;
    }

    @Override
    public String getName() {
        return Week.WHICH[this.index];
    }

    @Override
    public String toString() {
        return String.valueOf(this.month) + this.getName();
    }

    @Override
    public SolarWeek next(int n) {
        int add;
        if (n == 0) {
            return SolarWeek.fromYm(this.getYear(), this.getMonth(), this.index, this.start.getIndex());
        }
        int d = this.index + n;
        SolarMonth m = this.month;
        int startIndex = this.start.getIndex();
        int weeksInMonth = m.getWeekCount(startIndex);
        boolean forward = n > 0;
        int n2 = add = forward ? 1 : -1;
        while (forward ? d >= weeksInMonth : d < 0) {
            if (forward) {
                d -= weeksInMonth;
            } else if (!SolarDay.fromYmd(m.getYear(), m.getMonth(), 1).getWeek().equals(this.start)) {
                d += add;
            }
            m = m.next(add);
            if (forward && !SolarDay.fromYmd(m.getYear(), m.getMonth(), 1).getWeek().equals(this.start)) {
                d += add;
            }
            weeksInMonth = m.getWeekCount(startIndex);
            if (forward) continue;
            d += weeksInMonth;
        }
        return SolarWeek.fromYm(m.getYear(), m.getMonth(), d, startIndex);
    }

    public SolarDay getFirstDay() {
        SolarDay firstDay = SolarDay.fromYmd(this.getYear(), this.getMonth(), 1);
        return firstDay.next(this.index * 7 - this.indexOf(firstDay.getWeek().getIndex() - this.start.getIndex(), 7));
    }

    public List<SolarDay> getDays() {
        ArrayList<SolarDay> l = new ArrayList<SolarDay>(7);
        SolarDay d = this.getFirstDay();
        l.add(d);
        for (int i = 1; i < 7; ++i) {
            l.add(d.next(i));
        }
        return l;
    }
}

