/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.format;

import java.io.Serializable;
import java.util.function.Function;
import org.miaixz.bus.core.center.date.culture.en.Units;
import org.miaixz.bus.core.xyz.StringKit;

public class FormatPeriod
implements Serializable {
    private static final long serialVersionUID = -1L;
    private final int levelMaxCount;
    private long betweenMs;
    private Level level;
    private Function<Level, String> formatter = Level::getName;
    private boolean simpleMode = true;
    private String separator = "";

    public FormatPeriod(long betweenMs, Level level, int levelMaxCount) {
        this.betweenMs = betweenMs;
        this.level = level;
        this.levelMaxCount = levelMaxCount;
    }

    public static FormatPeriod of(long betweenMs, Level level) {
        return FormatPeriod.of(betweenMs, level, 0);
    }

    public static FormatPeriod of(long betweenMs, Level level, int levelMaxCount) {
        return new FormatPeriod(betweenMs, level, levelMaxCount);
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        if (this.betweenMs > 0L) {
            long day = this.betweenMs / Units.DAY.getMillis();
            long hour = this.betweenMs / Units.HOUR.getMillis() - day * 24L;
            long minute = this.betweenMs / Units.MINUTE.getMillis() - day * 24L * 60L - hour * 60L;
            long BetweenOfSecond = ((day * 24L + hour) * 60L + minute) * 60L;
            long second = this.betweenMs / Units.SECOND.getMillis() - BetweenOfSecond;
            long millisecond = this.betweenMs - (BetweenOfSecond + second) * 1000L;
            int level = this.level.ordinal();
            int levelCount = 0;
            if (this.isLevelCountValid(levelCount) && day > 0L) {
                sb.append(day).append(this.formatter.apply(Level.DAY)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && level >= Level.HOUR.ordinal() && (hour > 0L || !this.simpleMode && StringKit.isNotEmpty(sb))) {
                sb.append(hour).append(this.formatter.apply(Level.HOUR)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && level >= Level.MINUTE.ordinal() && (minute > 0L || !this.simpleMode && StringKit.isNotEmpty(sb))) {
                sb.append(minute).append(this.formatter.apply(Level.MINUTE)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && level >= Level.SECOND.ordinal() && (second > 0L || !this.simpleMode && StringKit.isNotEmpty(sb))) {
                sb.append(second).append(this.formatter.apply(Level.SECOND)).append(this.separator);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && millisecond > 0L && level >= Level.MILLISECOND.ordinal()) {
                sb.append(millisecond).append(this.formatter.apply(Level.MILLISECOND)).append(this.separator);
            }
        }
        if (StringKit.isEmpty(sb)) {
            sb.append(0).append(this.formatter.apply(this.level));
        } else if (StringKit.isNotEmpty(this.separator)) {
            sb.delete(sb.length() - this.separator.length(), sb.length());
        }
        return sb.toString().trim();
    }

    public long getBetweenMs() {
        return this.betweenMs;
    }

    public FormatPeriod setBetweenMs(long betweenMs) {
        this.betweenMs = betweenMs;
        return this;
    }

    public Level getLevel() {
        return this.level;
    }

    public FormatPeriod setLevel(Level level) {
        this.level = level;
        return this;
    }

    public FormatPeriod setSimpleMode(boolean simpleMode) {
        this.simpleMode = simpleMode;
        return this;
    }

    public FormatPeriod setFormatter(Function<Level, String> formatter) {
        this.formatter = formatter;
        return this;
    }

    public FormatPeriod setSeparator(String separator) {
        this.separator = StringKit.toStringOrEmpty(separator);
        return this;
    }

    public String toString() {
        return this.format();
    }

    private boolean isLevelCountValid(int levelCount) {
        return this.levelMaxCount <= 0 || levelCount < this.levelMaxCount;
    }

    public static enum Level {
        DAY("\u5929"),
        HOUR("\u5c0f\u65f6"),
        MINUTE("\u5206"),
        SECOND("\u79d2"),
        MILLISECOND("\u6beb\u79d2");

        private final String name;

        private Level(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

