/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.miaixz.bus.core.xyz.ExceptionKit;

@FunctionalInterface
public interface ConsumerX<T>
extends Consumer<T>,
Serializable {
    @SafeVarargs
    public static <T> ConsumerX<T> multi(ConsumerX<T> ... consumers) {
        return Stream.of(consumers).reduce(ConsumerX::andThen).orElseGet(() -> o -> {});
    }

    public static <T> ConsumerX<T> nothing() {
        return t -> {};
    }

    public void accepting(T var1) throws Throwable;

    @Override
    default public void accept(T t) {
        try {
            this.accepting(t);
        }
        catch (Throwable e) {
            throw ExceptionKit.wrapRuntime(e);
        }
    }

    @Override
    default public ConsumerX<T> andThen(ConsumerX<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }
}

