/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.miaixz.bus.core.lang.Chain;
import org.miaixz.bus.core.xyz.ArrayKit;

public class IteratorChain<T>
implements Iterator<T>,
Chain<Iterator<T>, IteratorChain<T>> {
    protected final List<Iterator<T>> allIterators = new ArrayList<Iterator<T>>();
    protected int currentIter = -1;

    public IteratorChain() {
    }

    @SafeVarargs
    public IteratorChain(Iterator<T> ... iterators) {
        if (ArrayKit.isNotEmpty(iterators)) {
            for (Iterator<T> iterator : iterators) {
                this.addChain(iterator);
            }
        }
    }

    @Override
    public IteratorChain<T> addChain(Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        if (this.allIterators.contains(iterator)) {
            throw new IllegalArgumentException("Duplicate iterator");
        }
        this.allIterators.add(iterator);
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIter == -1) {
            this.currentIter = 0;
        }
        int size = this.allIterators.size();
        for (int i = this.currentIter; i < size; ++i) {
            Iterator<T> iterator = this.allIterators.get(i);
            if (!iterator.hasNext()) continue;
            this.currentIter = i;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.allIterators.get(this.currentIter).next();
    }

    @Override
    public void remove() {
        if (-1 == this.currentIter) {
            throw new IllegalStateException("next() has not yet been called");
        }
        this.allIterators.get(this.currentIter).remove();
    }

    @Override
    public Iterator<Iterator<T>> iterator() {
        return this.allIterators.iterator();
    }
}

