/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.miaixz.bus.core.codec.Encoder;
import org.miaixz.bus.core.codec.binary.provider.Base16Provider;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.HexKit;
import org.miaixz.bus.core.xyz.StringKit;

public class PercentCodec
implements Encoder<byte[], byte[]>,
Serializable {
    private static final long serialVersionUID = -1L;
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public PercentCodec() {
        this(new BitSet(512));
    }

    public PercentCodec(BitSet safeCharacters) {
        this.safeCharacters = safeCharacters;
    }

    public boolean isSafe(char c) {
        return this.safeCharacters.get(c);
    }

    @Override
    public byte[] encode(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length * 3);
        for (int i = 0; i < bytes.length; ++i) {
            this.encodeTo(buffer, bytes[i]);
        }
        return buffer.array();
    }

    public String encode(CharSequence path, Charset charset, char ... customSafeChar) {
        if (null == charset || StringKit.isEmpty(path)) {
            return StringKit.toStringOrNull(path);
        }
        StringBuilder rewrittenPath = new StringBuilder(path.length() * 3);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i = 0; i < path.length(); ++i) {
            byte[] ba;
            char c = path.charAt(i);
            if (this.safeCharacters.get(c) || ArrayKit.contains(customSafeChar, c)) {
                rewrittenPath.append(c);
                continue;
            }
            if (this.encodeSpaceAsPlus && c == ' ') {
                rewrittenPath.append('+');
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                HexKit.appendHex(rewrittenPath, toEncode, false);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    private void encodeTo(ByteBuffer buffer, byte b) {
        if (this.safeCharacters.get(b)) {
            buffer.put(b);
        } else if (this.encodeSpaceAsPlus && b == 32) {
            buffer.put((byte)43);
        } else {
            buffer.put((byte)37);
            buffer.put((byte)Base16Provider.CODEC_UPPER.hexDigit(b >> 4));
            buffer.put((byte)Base16Provider.CODEC_UPPER.hexDigit(b));
        }
    }

    public static class Builder
    implements org.miaixz.bus.core.Builder<PercentCodec> {
        private static final long serialVersionUID = -1L;
        private final PercentCodec codec;

        private Builder(PercentCodec codec) {
            this.codec = codec;
        }

        public static Builder of(PercentCodec codec) {
            return new Builder(new PercentCodec((BitSet)codec.safeCharacters.clone()));
        }

        public static Builder of(CharSequence chars) {
            Assert.notNull(chars, "chars must not be null", new Object[0]);
            Builder builder = Builder.of(new PercentCodec());
            int length = chars.length();
            for (int i = 0; i < length; ++i) {
                builder.addSafe(chars.charAt(i));
            }
            return builder;
        }

        public Builder addSafe(char c) {
            this.codec.safeCharacters.set(c);
            return this;
        }

        public Builder addSafes(String chars) {
            int length = chars.length();
            for (int i = 0; i < length; ++i) {
                this.addSafe(chars.charAt(i));
            }
            return this;
        }

        public Builder removeSafe(char c) {
            this.codec.safeCharacters.clear(c);
            return this;
        }

        public Builder or(PercentCodec otherCodec) {
            this.codec.safeCharacters.or(otherCodec.safeCharacters);
            return this;
        }

        public Builder setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
            this.codec.encodeSpaceAsPlus = encodeSpaceAsPlus;
            return this;
        }

        @Override
        public PercentCodec build() {
            return this.codec;
        }
    }
}

