/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.miaixz.bus.core.codec.binary.decoder.Base64Decoder;
import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Base64 {
    public static byte[] encode(byte[] arr, boolean lineSep) {
        if (arr == null) {
            return null;
        }
        return lineSep ? java.util.Base64.getMimeEncoder().encode(arr) : java.util.Base64.getEncoder().encode(arr);
    }

    public static String encode(CharSequence source) {
        return Base64.encode(source, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String encodeUrlSafe(CharSequence source) {
        return Base64.encodeUrlSafe(source, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String encode(CharSequence source, Charset charset) {
        return Base64.encode(ByteKit.toBytes(source, charset));
    }

    public static String encodeUrlSafe(CharSequence source, Charset charset) {
        return Base64.encodeUrlSafe(ByteKit.toBytes(source, charset));
    }

    public static String encode(byte[] source) {
        if (source == null) {
            return null;
        }
        return java.util.Base64.getEncoder().encodeToString(source);
    }

    public static String encodeWithoutPadding(byte[] source) {
        if (source == null) {
            return null;
        }
        return java.util.Base64.getEncoder().withoutPadding().encodeToString(source);
    }

    public static String encodeUrlSafe(byte[] source) {
        if (source == null) {
            return null;
        }
        return java.util.Base64.getUrlEncoder().withoutPadding().encodeToString(source);
    }

    public static String encode(InputStream in) {
        if (in == null) {
            return null;
        }
        return Base64.encode(IoKit.readBytes(in));
    }

    public static String encodeUrlSafe(InputStream in) {
        if (in == null) {
            return null;
        }
        return Base64.encodeUrlSafe(IoKit.readBytes(in));
    }

    public static String encode(File file) {
        return Base64.encode(FileKit.readBytes(file));
    }

    public static String encodeUrlSafe(File file) {
        return Base64.encodeUrlSafe(FileKit.readBytes(file));
    }

    public static void encode(byte[] src, int srcPos, int srcLen, char[] dest, int destPos) {
        byte b2;
        byte b1;
        if (srcPos < 0 || srcLen < 0 || srcLen > src.length - srcPos) {
            throw new IndexOutOfBoundsException();
        }
        int destLen = srcLen * 4 / 3 + 3 & 0xFFFFFFFC;
        if (destPos < 0 || destLen > dest.length - destPos) {
            throw new IndexOutOfBoundsException();
        }
        int n = srcLen / 3;
        int r = srcLen - 3 * n;
        while (n-- > 0) {
            int n2 = destPos++;
            b1 = src[srcPos++];
            dest[n2] = CharKit.getChars(Normal.ENCODE_64_TABLE)[b1 >>> 2 & 0x3F];
            int n3 = destPos++;
            b2 = src[srcPos++];
            dest[n3] = CharKit.getChars(Normal.ENCODE_64_TABLE)[(b1 & 3) << 4 | b2 >>> 4 & 0xF];
            int n4 = destPos++;
            byte b3 = src[srcPos++];
            dest[n4] = CharKit.getChars(Normal.ENCODE_64_TABLE)[(b2 & 0xF) << 2 | b3 >>> 6 & 3];
            dest[destPos++] = CharKit.getChars(Normal.ENCODE_64_TABLE)[b3 & 0x3F];
        }
        if (r > 0) {
            if (r == 1) {
                int n5 = destPos++;
                b1 = src[srcPos];
                dest[n5] = CharKit.getChars(Normal.ENCODE_64_TABLE)[b1 >>> 2 & 0x3F];
                dest[destPos++] = CharKit.getChars(Normal.ENCODE_64_TABLE)[(b1 & 3) << 4];
                dest[destPos++] = 61;
                dest[destPos++] = 61;
            } else {
                int n6 = destPos++;
                b1 = src[srcPos++];
                dest[n6] = CharKit.getChars(Normal.ENCODE_64_TABLE)[b1 >>> 2 & 0x3F];
                int n7 = destPos++;
                b2 = src[srcPos];
                dest[n7] = CharKit.getChars(Normal.ENCODE_64_TABLE)[(b1 & 3) << 4 | b2 >>> 4 & 0xF];
                dest[destPos++] = CharKit.getChars(Normal.ENCODE_64_TABLE)[(b2 & 0xF) << 2];
                dest[destPos++] = 61;
            }
        }
    }

    public static String decodeString(CharSequence source) {
        return Base64.decodeString(source, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String decodeString(CharSequence source, Charset charset) {
        return StringKit.toString(Base64.decode(source), charset);
    }

    public static File decodeToFile(CharSequence base64, File destFile) {
        return FileKit.writeBytes(Base64.decode(base64), destFile);
    }

    public static void decodeToStream(CharSequence base64, OutputStream out, boolean isCloseOut) {
        IoKit.write(out, isCloseOut, Base64.decode(base64));
    }

    public static byte[] decode(CharSequence base64) {
        return Base64.decode(ByteKit.toBytes(base64, org.miaixz.bus.core.lang.Charset.UTF_8));
    }

    public static byte[] decode(byte[] in) {
        return Base64Decoder.INSTANCE.decode(in);
    }

    public static void decode(char[] ch, int off, int len, OutputStream out) {
        try {
            while ((len -= 2) >= 0) {
                int n = off++;
                byte b2 = Normal.DECODE_64_TABLE[ch[off++]];
                out.write((byte)(Normal.DECODE_64_TABLE[ch[n]] << 2 | b2 >>> 4));
                if (len-- != 0 && ch[off] != '=') {
                    byte b3 = Normal.DECODE_64_TABLE[ch[off++]];
                    out.write((byte)(b2 << 4 | b3 >>> 2));
                    if (len-- != 0 && ch[off] != '=') {
                        out.write((byte)(b3 << 6 | Normal.DECODE_64_TABLE[ch[off++]]));
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static boolean isTypeBase64(CharSequence base64) {
        if (base64 == null || base64.length() < 2) {
            return false;
        }
        byte[] bytes = ByteKit.toBytes(base64);
        if (bytes.length != base64.length()) {
            return false;
        }
        return Base64.isTypeBase64(bytes);
    }

    public static boolean isTypeBase64(byte[] base64Bytes) {
        if (base64Bytes == null || base64Bytes.length < 3) {
            return false;
        }
        boolean hasPadding = false;
        for (byte base64Byte : base64Bytes) {
            if (hasPadding) {
                if (61 == base64Byte) continue;
                return false;
            }
            if (61 == base64Byte) {
                hasPadding = true;
                continue;
            }
            if (Base64Decoder.INSTANCE.isBase64Code(base64Byte) || Base64.isWhiteSpace(base64Byte)) continue;
            return false;
        }
        return true;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

