/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary.decoder;

import java.util.Arrays;
import org.miaixz.bus.core.codec.Decoder;

public class Base32Decoder
implements Decoder<CharSequence, byte[]> {
    public static final Base32Decoder DECODER = new Base32Decoder("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");
    public static final Base32Decoder HEX_DECODER = new Base32Decoder("0123456789ABCDEFGHIJKLMNOPQRSTUV");
    private final byte[] lookupTable = new byte[128];

    public Base32Decoder(String alphabet) {
        Arrays.fill(this.lookupTable, (byte)-1);
        int length = alphabet.length();
        for (int i = 0; i < length; ++i) {
            char c = alphabet.charAt(i);
            this.lookupTable[c - 48] = (byte)i;
            if (c < 'A' || c > 'Z') continue;
            this.lookupTable[Character.toLowerCase((char)c) - 48] = (byte)i;
        }
    }

    @Override
    public byte[] decode(CharSequence encoded) {
        String base32 = encoded.toString();
        int len = base32.endsWith("=") ? base32.indexOf("=") * 5 / 8 : base32.length() * 5 / 8;
        byte[] bytes = new byte[len];
        int index = 0;
        int offset = 0;
        for (int i = 0; i < base32.length(); ++i) {
            byte digit;
            int lookup = base32.charAt(i) - 48;
            if (lookup < 0 || lookup >= this.lookupTable.length || (digit = this.lookupTable[lookup]) < 0) continue;
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n = offset++;
                    bytes[n] = (byte)(bytes[n] | digit);
                    if (offset < bytes.length) continue;
                    break;
                }
                int n = offset;
                bytes[n] = (byte)(bytes[n] | digit << 8 - index);
                continue;
            }
            index = (index + 5) % 8;
            int n = offset++;
            bytes[n] = (byte)(bytes[n] | digit >>> index);
            if (offset >= bytes.length) break;
            int n2 = offset;
            bytes[n2] = (byte)(bytes[n2] | digit << 8 - index);
        }
        return bytes;
    }
}

