/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.compare;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.miaixz.bus.core.xyz.StringKit;

public class ExplorerCompare
implements Comparator<CharSequence> {
    public static final ExplorerCompare INSTANCE = new ExplorerCompare();

    @Override
    public int compare(CharSequence str1, CharSequence str2) {
        int result;
        Iterator<String> i1 = this.splitStringPreserveDelimiter(str1).iterator();
        Iterator<String> i2 = this.splitStringPreserveDelimiter(str2).iterator();
        do {
            if (!i1.hasNext() && !i2.hasNext()) {
                return 0;
            }
            if (!i1.hasNext()) {
                return -1;
            }
            if (!i2.hasNext()) {
                return 1;
            }
            String data1 = i1.next();
            String data2 = i2.next();
            try {
                result = Long.compare(Long.parseLong(data1), Long.parseLong(data2));
                if (result != 0) continue;
                result = -Integer.compare(data1.length(), data2.length());
            }
            catch (NumberFormatException ex) {
                result = data1.compareToIgnoreCase(data2);
            }
        } while (result == 0);
        return result;
    }

    private List<String> splitStringPreserveDelimiter(CharSequence text) {
        Matcher matcher = Pattern.compile("\\d+|\\.|\\s").matcher(text);
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (matcher.find()) {
            list.add(StringKit.sub(text, pos, matcher.start()));
            list.add(matcher.group());
            pos = matcher.end();
        }
        list.add(StringKit.subSuf(text, pos));
        return list;
    }
}

