/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.miaixz.bus.core.io.compress.ZipResource;
import org.miaixz.bus.core.io.compress.ZipSecurity;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;

public class ZipStream
implements ZipResource {
    private final ZipInputStream in;

    public ZipStream(ZipInputStream in) {
        this.in = in;
    }

    @Override
    public void read(Consumer<ZipEntry> consumer, int maxSizeDiff) {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                consumer.accept(zipEntry);
                ZipSecurity.checkZipBomb(zipEntry, maxSizeDiff);
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public InputStream get(String path) {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                if (!zipEntry.getName().equals(path)) continue;
                return this.in;
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return null;
    }

    @Override
    public InputStream get(ZipEntry entry) {
        return this.in;
    }

    @Override
    public void close() throws IOException {
        IoKit.closeQuietly(this.in);
    }
}

