/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.watch;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.io.watch.WatchKind;
import org.miaixz.bus.core.io.watch.Watcher;
import org.miaixz.bus.core.lang.Wrapper;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.IoKit;

public class WatchServiceWrapper
implements WatchService,
Wrapper<WatchService>,
Serializable {
    private static final long serialVersionUID = -1L;
    private final WatchService watchService;
    private WatchEvent.Kind<?>[] events;
    private WatchEvent.Modifier[] modifiers;
    private boolean isClosed;

    public WatchServiceWrapper(WatchEvent.Kind<?> ... events) {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        this.events = events;
    }

    public static WatchServiceWrapper of(WatchEvent.Kind<?> ... events) {
        return new WatchServiceWrapper(events);
    }

    @Override
    public WatchService getRaw() {
        return this.watchService;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            IoKit.closeQuietly(this.watchService);
        }
    }

    @Override
    public WatchKey poll() {
        return this.watchService.poll();
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.watchService.poll(timeout, unit);
    }

    @Override
    public WatchKey take() throws InterruptedException {
        return this.watchService.take();
    }

    public WatchServiceWrapper setEvents(WatchKind ... kinds) {
        if (ArrayKit.isNotEmpty(kinds)) {
            this.setEvents(ArrayKit.mapToArray(kinds, WatchKind::getValue, WatchEvent.Kind[]::new));
        }
        return this;
    }

    public WatchServiceWrapper setEvents(WatchEvent.Kind<?> ... events) {
        this.events = events;
        return this;
    }

    public WatchServiceWrapper setModifiers(WatchEvent.Modifier ... modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public WatchKey register(Watchable watchable) {
        WatchKey watchKey;
        block2: {
            WatchEvent.Kind<?>[] kinds = ArrayKit.defaultIfEmpty(this.events, WatchKind.ALL);
            watchKey = null;
            try {
                watchKey = ArrayKit.isEmpty(this.modifiers) ? watchable.register(this.watchService, kinds) : watchable.register(this.watchService, kinds, this.modifiers);
            }
            catch (IOException e) {
                if (e instanceof AccessDeniedException) break block2;
                throw new InternalException(e);
            }
        }
        return watchKey;
    }

    public WatchServiceWrapper registerPath(Path path, int maxDepth) {
        if (null == this.register(path)) {
            return this;
        }
        PathResolve.walkFiles(path, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                WatchServiceWrapper.this.registerPath(dir, 0);
                return super.postVisitDirectory(dir, exc);
            }
        });
        return this;
    }

    public void watch(Watcher watcher, Predicate<WatchEvent<?>> watchFilter) {
        this.watch((WatchEvent<?> event, WatchKey watchKey) -> {
            WatchEvent.Kind kind = event.kind();
            if (kind == WatchKind.CREATE.getValue()) {
                watcher.onCreate((WatchEvent<?>)event, (WatchKey)watchKey);
            } else if (kind == WatchKind.MODIFY.getValue()) {
                watcher.onModify((WatchEvent<?>)event, (WatchKey)watchKey);
            } else if (kind == WatchKind.DELETE.getValue()) {
                watcher.onDelete((WatchEvent<?>)event, (WatchKey)watchKey);
            } else if (kind == WatchKind.OVERFLOW.getValue()) {
                watcher.onOverflow((WatchEvent<?>)event, (WatchKey)watchKey);
            }
        }, watchFilter);
    }

    public void watch(BiConsumer<WatchEvent<?>, WatchKey> action) {
        this.watch(action, null);
    }

    public void watch(BiConsumer<WatchEvent<?>, WatchKey> action, Predicate<WatchEvent<?>> watchFilter) {
        WatchKey wk;
        try {
            wk = this.watchService.take();
        }
        catch (InterruptedException | ClosedWatchServiceException e) {
            this.close();
            return;
        }
        for (WatchEvent<?> event : wk.pollEvents()) {
            if (null != watchFilter && !watchFilter.test(event)) continue;
            action.accept(event, wk);
        }
        wk.reset();
    }
}

