/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.method;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.Invoker;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ExceptionKit;
import org.miaixz.bus.core.xyz.LookupKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ModifierKit;

public class MethodInvoker
implements Invoker {
    private final Method method;
    private final Class<?>[] paramTypes;
    private final Class<?> type;
    private boolean checkArgs;

    public MethodInvoker(Method method) {
        this.method = method;
        this.paramTypes = method.getParameterTypes();
        this.type = this.paramTypes.length == 1 ? this.paramTypes[0] : method.getReturnType();
    }

    public static MethodInvoker of(Method method) {
        return new MethodInvoker(method);
    }

    public static <T> T invokeHandle(MethodHandle methodHandle, Object ... args) {
        try {
            return (T)methodHandle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw ExceptionKit.wrapRuntime(e);
        }
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws InternalException {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        return MethodInvoker.invokeExact(obj, method, MethodKit.actualArgs(method, args));
    }

    public static <T> T invokeExact(Object obj, Method method, Object ... args) throws InternalException {
        MethodHandle handle;
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        try {
            handle = LookupKit.unreflectMethod(method);
        }
        catch (Throwable e) {
            throw ExceptionKit.wrapRuntime(e);
        }
        if (null != obj) {
            handle = handle.bindTo(obj);
        }
        return MethodInvoker.invokeHandle(handle, args);
    }

    public MethodInvoker setCheckArgs(boolean checkArgs) {
        this.checkArgs = checkArgs;
        return this;
    }

    @Override
    public <T> T invoke(Object target, Object ... args) throws InternalException {
        Method method;
        if (this.checkArgs) {
            this.checkArgs(args);
        }
        if (ModifierKit.isStatic(method = this.method)) {
            target = null;
        }
        Object[] actualArgs = MethodKit.actualArgs(method, args);
        try {
            return MethodInvoker.invokeExact(target, method, actualArgs);
        }
        catch (Exception e) {
            try {
                return (T)method.invoke(target, actualArgs);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new InternalException(ex);
            }
        }
    }

    public <T> T invokeStatic(Object ... args) throws InternalException {
        return this.invoke(null, args);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    private void checkArgs(Object[] args) {
        Class<?>[] paramTypes = this.paramTypes;
        if (null != args) {
            Assert.isTrue(args.length == paramTypes.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, paramTypes.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = paramTypes[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassKit.getDefaultValue(type);
            }
        }
    }
}

