/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.placeholder.template;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.miaixz.bus.core.beans.desc.BeanDesc;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.text.placeholder.StringTemplate;
import org.miaixz.bus.core.text.placeholder.segment.AbstractSegment;
import org.miaixz.bus.core.text.placeholder.segment.IndexedSegment;
import org.miaixz.bus.core.text.placeholder.segment.LiteralSegment;
import org.miaixz.bus.core.text.placeholder.segment.NamedSegment;
import org.miaixz.bus.core.text.placeholder.segment.StringSegment;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.LambdaKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MathKit;

public class NamedStringTemplate
extends StringTemplate {
    public static final String DEFAULT_PREFIX = "{";
    public static final String DEFAULT_SUFFIX = "}";
    protected String prefix;
    protected String suffix;
    protected int indexedSegmentMaxIdx = 0;

    protected NamedStringTemplate(String template, int features, String prefix, String suffix, char escape, String defaultValue, UnaryOperator<String> defaultValueHandler) {
        super(template, escape, defaultValue, defaultValueHandler, features);
        Assert.notEmpty(prefix);
        Assert.notEmpty(suffix);
        this.prefix = prefix;
        this.suffix = suffix;
        this.afterInit();
        if (!this.placeholderSegments.isEmpty()) {
            for (AbstractSegment segment : this.placeholderSegments) {
                if (!(segment instanceof IndexedSegment)) continue;
                this.indexedSegmentMaxIdx = Math.max(this.indexedSegmentMaxIdx, ((IndexedSegment)segment).getIndex());
            }
        }
    }

    public static Builder builder(String template) {
        return new Builder(template);
    }

    @Override
    protected List<StringSegment> parseSegments(String template) {
        int openCursor = template.indexOf(this.prefix);
        if (openCursor == -1) {
            return Collections.singletonList(new LiteralSegment(template));
        }
        int openLength = this.prefix.length();
        int closeLength = this.suffix.length();
        ArrayList<StringSegment> segments = new ArrayList<StringSegment>();
        int closeCursor = 0;
        char[] src = template.toCharArray();
        StringBuilder expression = new StringBuilder(16);
        boolean hasDoubleEscape = false;
        boolean isLastLiteralSegment = false;
        while (openCursor > -1) {
            if (openCursor > 0 && src[openCursor - 1] == this.escape) {
                if (openCursor > 1 && src[openCursor - 2] == this.escape) {
                    hasDoubleEscape = true;
                } else {
                    this.addLiteralSegment(isLastLiteralSegment, segments, template.substring(closeCursor, openCursor - 1) + this.prefix);
                    isLastLiteralSegment = true;
                    closeCursor = openCursor + openLength;
                    openCursor = template.indexOf(this.prefix, closeCursor);
                    continue;
                }
            }
            if (!hasDoubleEscape) {
                if (closeCursor < openCursor) {
                    this.addLiteralSegment(isLastLiteralSegment, segments, template.substring(closeCursor, openCursor));
                }
            } else {
                hasDoubleEscape = false;
                this.addLiteralSegment(isLastLiteralSegment, segments, template.substring(closeCursor, openCursor - 1));
            }
            closeCursor = openCursor + openLength;
            int end = template.indexOf(this.suffix, closeCursor);
            while (end > -1) {
                if (end > closeCursor && src[end - 1] == this.escape) {
                    if (end > 1 && src[end - 2] == this.escape) {
                        expression.append(src, closeCursor, end - closeCursor - 1);
                        break;
                    }
                    expression.append(src, closeCursor, end - closeCursor - 1).append(this.suffix);
                    closeCursor = end + closeLength;
                    end = template.indexOf(this.suffix, closeCursor);
                    continue;
                }
                expression.append(src, closeCursor, end - closeCursor);
                break;
            }
            if (end == -1) {
                throw new InternalException("\"{}\" \u4e2d\u5b57\u7b26\u4e0b\u6807 {} \u5904\u7684\u5f00\u59cb\u7b26\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ed3\u675f\u7b26", template, openCursor);
            }
            String variableName = expression.toString();
            expression.setLength(0);
            String wholePlaceholder = expression.append(this.prefix).append(variableName).append(this.suffix).toString();
            expression.setLength(0);
            if (MathKit.isInteger(variableName)) {
                segments.add(new IndexedSegment(variableName, wholePlaceholder));
            } else {
                segments.add(new NamedSegment(variableName, wholePlaceholder));
            }
            isLastLiteralSegment = false;
            closeCursor = end + closeLength;
            openCursor = template.indexOf(this.prefix, closeCursor);
        }
        if (closeCursor < src.length) {
            this.addLiteralSegment(isLastLiteralSegment, segments, template.substring(closeCursor));
        }
        return segments;
    }

    public String formatSequence(Object ... args) {
        return this.formatArraySequence(args);
    }

    public String formatArraySequence(Object array) {
        return this.formatArraySequence(ArrayKit.wrap(array));
    }

    public String formatArraySequence(Object[] array) {
        if (array == null) {
            return this.getTemplate();
        }
        return this.formatSequence(Arrays.asList(array));
    }

    @Override
    public String formatSequence(Iterable<?> iterable) {
        return super.formatSequence(iterable);
    }

    public String formatIndexed(Object ... args) {
        return this.formatArrayIndexed(args);
    }

    public String formatArrayIndexed(Object array) {
        return this.formatArrayIndexed(ArrayKit.wrap(array));
    }

    public String formatArrayIndexed(Object[] array) {
        if (array == null) {
            return this.getTemplate();
        }
        return this.formatIndexed(Arrays.asList(array));
    }

    public String formatIndexed(Collection<?> collection) {
        return this.formatIndexed(collection, null);
    }

    public String formatIndexed(Collection<?> collection, IntFunction<String> missingIndexHandler) {
        if (collection == null) {
            return this.getTemplate();
        }
        int size = collection.size();
        boolean isList = collection instanceof List;
        return this.formatBySegment(segment -> {
            int index = ((IndexedSegment)segment).getIndex();
            if (index < 0) {
                index += size;
            }
            if (index >= 0 && index < size) {
                if (isList) {
                    return ((List)collection).get(index);
                }
                return CollKit.get(collection, index);
            }
            if (missingIndexHandler != null) {
                return missingIndexHandler.apply(index);
            }
            return this.formatMissingKey((AbstractSegment)segment);
        });
    }

    public String format(Object beanOrMap) {
        if (beanOrMap == null) {
            return this.getTemplate();
        }
        if (beanOrMap instanceof Map) {
            return this.format((Map)beanOrMap);
        }
        if (BeanKit.isReadableBean(beanOrMap.getClass())) {
            BeanDesc beanDesc = BeanKit.getBeanDesc(beanOrMap.getClass());
            return this.format((String fieldName) -> {
                Method getterMethod = beanDesc.getGetter((String)fieldName);
                if (getterMethod == null) {
                    return null;
                }
                return LambdaKit.buildGetter(getterMethod).apply(beanOrMap);
            });
        }
        return this.format((String fieldName) -> BeanKit.getProperty(beanOrMap, fieldName));
    }

    public String format(Map<String, ?> map) {
        if (map == null) {
            return this.getTemplate();
        }
        return this.format(map::get, map::containsKey);
    }

    public String format(Function<String, ?> valueSupplier) {
        if (valueSupplier == null) {
            return this.getTemplate();
        }
        return this.formatBySegment(segment -> valueSupplier.apply(segment.getPlaceholder()));
    }

    public String format(Function<String, ?> valueSupplier, Predicate<String> containsKey) {
        if (valueSupplier == null || containsKey == null) {
            return this.getTemplate();
        }
        return this.formatBySegment(segment -> {
            String placeholder = segment.getPlaceholder();
            if (containsKey.test(placeholder)) {
                return valueSupplier.apply(placeholder);
            }
            return this.formatMissingKey((AbstractSegment)segment);
        });
    }

    public String[] matchesSequenceToArray(String text) {
        return this.matchesSequence(text).toArray(new String[0]);
    }

    @Override
    public List<String> matchesSequence(String text) {
        return super.matchesSequence(text);
    }

    public String[] matchesIndexedToArray(String text) {
        return this.matchesIndexed(text, null).toArray(new String[0]);
    }

    public String[] matchesIndexedToArray(String text, IntFunction<String> missingIndexHandler) {
        return this.matchesIndexed(text, missingIndexHandler).toArray(new String[0]);
    }

    public List<String> matchesIndexed(String text) {
        return this.matchesIndexed(text, null);
    }

    public List<String> matchesIndexed(String text, IntFunction<String> missingIndexHandler) {
        if (text == null || this.placeholderSegments.isEmpty() || !this.isMatches(text)) {
            return ListKit.zero();
        }
        ArrayList<String> params = new ArrayList<String>(this.indexedSegmentMaxIdx + 1);
        ListKit.setOrPadding(params, this.indexedSegmentMaxIdx, null, null);
        this.matchesIndexed(text, params::set, missingIndexHandler);
        return params;
    }

    public void matchesIndexed(String text, BiConsumer<Integer, String> idxValueConsumer, IntFunction<String> missingIndexHandler) {
        if (text == null || CollKit.isEmpty(this.placeholderSegments) || !this.isMatches(text)) {
            return;
        }
        if (missingIndexHandler == null) {
            this.matchesByKey(text, (key, value) -> idxValueConsumer.accept(Integer.parseInt(key), (String)value));
        } else {
            this.matchesByKey(text, (key, value) -> idxValueConsumer.accept(Integer.parseInt(key), (String)value), true, segment -> {
                if (segment instanceof IndexedSegment) {
                    return (String)missingIndexHandler.apply(((IndexedSegment)segment).getIndex());
                }
                return this.getDefaultValue((AbstractSegment)segment);
            });
        }
    }

    public Map<String, String> matches(String text) {
        return this.matches(text, HashMap::new);
    }

    public <T> T matches(String text, Supplier<T> beanOrMapSupplier) {
        Assert.notNull(beanOrMapSupplier, "beanOrMapSupplier cannot be null", new Object[0]);
        Object obj = beanOrMapSupplier.get();
        if (text == null || obj == null || this.placeholderSegments.isEmpty() || !this.isMatches(text)) {
            return obj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            this.matchesByKey(text, map::put);
        } else if (BeanKit.isWritableBean(obj.getClass())) {
            this.matchesByKey(text, (key, value) -> BeanKit.setProperty(obj, key, value));
        }
        return obj;
    }

    public static class Builder
    extends StringTemplate.AbstractBuilder<Builder, NamedStringTemplate> {
        protected String prefix;
        protected String suffix;

        protected Builder(String template) {
            super(template);
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        @Override
        protected NamedStringTemplate buildInstance() {
            if (this.prefix == null) {
                this.prefix = NamedStringTemplate.DEFAULT_PREFIX;
            }
            if (this.suffix == null) {
                this.suffix = NamedStringTemplate.DEFAULT_SUFFIX;
            }
            return new NamedStringTemplate(this.template, this.features, this.prefix, this.suffix, this.escape, this.defaultValue, this.defaultValueHandler);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

