/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.replacer;

import org.miaixz.bus.core.text.replacer.StringReplacer;
import org.miaixz.bus.core.xyz.StringKit;

public class StringRangeReplacer
extends StringReplacer {
    private static final long serialVersionUID = -1L;
    private final int beginInclude;
    private final int endExclude;
    private final CharSequence replacedStr;
    private final boolean isCodePoint;

    public StringRangeReplacer(int beginInclude, int endExclude, CharSequence replacedStr, boolean isCodePoint) {
        this.beginInclude = beginInclude;
        this.endExclude = endExclude;
        this.replacedStr = replacedStr;
        this.isCodePoint = isCodePoint;
    }

    @Override
    public String apply(CharSequence text) {
        int i;
        if (StringKit.isEmpty(text)) {
            return StringKit.toStringOrNull(text);
        }
        int beginInclude = this.beginInclude;
        String originalStr = text.toString();
        int[] chars = StringKit.toChars(originalStr, this.isCodePoint);
        int strLength = chars.length;
        if (beginInclude > strLength) {
            return originalStr;
        }
        int endExclude = this.endExclude;
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (beginInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder(originalStr.length() - (endExclude - beginInclude) + this.replacedStr.length());
        for (i = 0; i < beginInclude; ++i) {
            this.append(stringBuilder, chars[i]);
        }
        this.replace(originalStr, beginInclude, stringBuilder);
        for (i = endExclude; i < strLength; ++i) {
            this.append(stringBuilder, chars[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected int replace(CharSequence text, int pos, StringBuilder out) {
        out.append(this.replacedStr);
        return this.endExclude;
    }

    private void append(StringBuilder stringBuilder, int c) {
        if (this.isCodePoint) {
            stringBuilder.appendCodePoint(c);
        } else {
            stringBuilder.append((char)c);
        }
    }
}

